/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.jms;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jms.Destination;
import org.jboss.seam.jms.JmsMessage;
import org.jboss.seam.jms.MessageManager;
import org.jboss.solder.logging.Logger;

public class JmsMessageImpl
implements JmsMessage {
    private MessageManager messageManager;
    private String selector = null;
    private Class<?> payloadType;
    private Object payload;
    private List<Destination> destinations;
    private Map<String, Object> headers;
    private Map<String, Object> properties;
    private Logger logger = Logger.getLogger(JmsMessageImpl.class);

    protected JmsMessageImpl(Class<?> payloadType, Object payload, MessageManager messageManager) {
        this.payloadType = payloadType;
        this.payload(payload);
        this.messageManager = messageManager;
        this.destinations = new ArrayList<Destination>();
        this.headers = new HashMap<String, Object>();
        this.properties = new HashMap<String, Object>();
    }

    public JmsMessage destination(Destination destination) {
        this.destinations.add(destination);
        return this;
    }

    public JmsMessage destination(String jndiName) {
        Destination d = this.messageManager.lookupDestination(jndiName);
        if (d == null) {
            this.logger.warn((Object)("Unable to find a destination at " + jndiName));
            return this;
        }
        return this.destination(d);
    }

    public JmsMessage headers(Map<String, Object> headers) {
        this.headers = headers;
        return this;
    }

    public JmsMessage properties(Map<String, Object> properties) {
        this.properties = properties;
        return this;
    }

    public JmsMessage payload(Object payload) {
        this.payload = payload;
        return this;
    }

    public JmsMessage selector(String selector) {
        this.selector = selector;
        return this;
    }

    public Class<?> getPayloadType() {
        return this.payloadType;
    }

    public Object getPayload() {
        return this.payload;
    }

    public Map<String, Object> getHeaders() {
        return this.headers;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public String getSelector() {
        return this.selector;
    }

    public List<Destination> getDestinations() {
        return this.destinations;
    }
}

