/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.jms;

import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.jms.TopicSubscriber;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.seam.jms.JmsMessage;
import org.jboss.seam.jms.JmsMessageImpl;
import org.jboss.seam.jms.MessageManager;
import org.jboss.seam.jms.QueueBuilder;
import org.jboss.seam.jms.QueueBuilderImpl;
import org.jboss.seam.jms.TopicBuilder;
import org.jboss.seam.jms.TopicBuilderImpl;
import org.jboss.seam.jms.annotations.JmsDefault;
import org.jboss.solder.exception.control.ExceptionToCatch;
import org.jboss.solder.logging.Logger;

@Dependent
public class MessageManagerImpl
implements MessageManager {
    @Inject
    @JmsDefault(value="session")
    Session session;
    @Inject
    Event<ExceptionToCatch> exceptionEvent;
    private Logger logger = Logger.getLogger(MessageManagerImpl.class);

    public ObjectMessage createObjectMessage(Object object) {
        if (!(object instanceof Serializable)) {
            throw new IllegalArgumentException("Objects must be serializable to be sent over JMS.");
        }
        try {
            return this.session.createObjectMessage((Serializable)object);
        }
        catch (JMSException e) {
            this.logger.error((Object)"Unable to create object message.", (Throwable)e);
            throw new RuntimeException("Error when creating object message", e);
        }
    }

    public TextMessage createTextMessage(String string) {
        try {
            TextMessage tm = this.session.createTextMessage();
            tm.setText(string);
            return tm;
        }
        catch (JMSException e) {
            this.logger.error((Object)"Unable to create text message.", (Throwable)e);
            throw new RuntimeException("Error when creating text message", e);
        }
    }

    public MapMessage createMapMessage(Map<Object, Object> map) {
        try {
            MapMessage msg = this.session.createMapMessage();
            Set<Object> keys = map.keySet();
            for (Object key : keys) {
                Object value = map.get(key);
                msg.setObject(key.toString(), value);
            }
            return msg;
        }
        catch (JMSException e) {
            this.logger.error((Object)"Unable to create map message.", (Throwable)e);
            throw new RuntimeException("Error when creating map message", e);
        }
    }

    public BytesMessage createBytesMessage(byte[] bytes) {
        try {
            BytesMessage bm = this.session.createBytesMessage();
            bm.writeBytes(bytes);
            return bm;
        }
        catch (JMSException e) {
            this.logger.error((Object)"Unable to create bytes message", (Throwable)e);
            throw new RuntimeException("Error creating bytes message", e);
        }
    }

    public void sendObjectToDestinations(Object object, String ... destinations) {
        this.sendMessage((Message)this.createObjectMessage(object), destinations);
    }

    public void sendTextToDestinations(String string, String ... destinations) {
        this.sendMessage((Message)this.createTextMessage(string), destinations);
    }

    public void sendMapToDestinations(Map map, String ... destinations) {
        this.sendMessage((Message)this.createMapMessage(map), destinations);
    }

    public void sendBytesToDestinations(byte[] bytes, String ... destinations) {
        this.sendMessage((Message)this.createBytesMessage(bytes), destinations);
    }

    public Destination lookupDestination(String jndiName) {
        try {
            InitialContext c = new InitialContext();
            return (Destination)c.lookup(jndiName);
        }
        catch (NamingException e) {
            this.logger.warn((Object)("Unable to lookup " + jndiName), (Throwable)e);
            return null;
        }
    }

    protected void sendMessage(String jndiName, Message message) {
        Destination d = this.lookupDestination(jndiName);
        this.sendMessage(d, message);
    }

    private void sendMessage(Destination destination, Message message) {
        try {
            this.logger.info((Object)("Routing destination " + destination + " with message " + message));
            this.createMessageProducer(destination).send(message);
        }
        catch (JMSException e) {
            this.logger.warn((Object)("Problem attempting to send message " + message + " to destination " + destination), (Throwable)e);
        }
    }

    public void sendMessage(Message message, Destination ... destinations) {
        for (Destination destination : destinations) {
            this.sendMessage(destination, message);
        }
    }

    public void sendMessage(Message message, String ... destinations) {
        for (String destination : destinations) {
            this.sendMessage(destination, message);
        }
    }

    public void sendObjectToDestinations(Object object, Destination ... destinations) {
        this.sendMessage((Message)this.createObjectMessage(object), destinations);
    }

    public void sendTextToDestinations(String string, Destination ... destinations) {
        this.sendMessage((Message)this.createTextMessage(string), destinations);
    }

    public void sendMapToDestinations(Map map, Destination ... destinations) {
        this.sendMessage((Message)this.createMapMessage(map), destinations);
    }

    public void sendBytesToDestinations(byte[] bytes, Destination ... destinations) {
        this.sendMessage((Message)this.createBytesMessage(bytes), destinations);
    }

    public Session getSession() {
        return this.session;
    }

    public MessageConsumer createMessageConsumer(String destination, MessageListener ... listeners) {
        try {
            MessageConsumer mc = this.session.createConsumer(this.lookupDestination(destination));
            if (mc != null && listeners != null) {
                for (MessageListener listener : listeners) {
                    try {
                        mc.setMessageListener(listener);
                    }
                    catch (JMSException e) {
                        this.logger.warn((Object)("Unable to map listener " + listener + " to consumer " + mc), (Throwable)e);
                    }
                }
            }
            return mc;
        }
        catch (JMSException e) {
            this.logger.warn((Object)"Unable to create message consumer", (Throwable)e);
            return null;
        }
    }

    public MessageConsumer createMessageConsumer(String destination, String selector, MessageListener ... listeners) {
        return this.createMessageConsumer(this.lookupDestination(destination), selector, listeners);
    }

    public MessageConsumer createMessageConsumer(Destination destination, String selector, MessageListener ... listeners) {
        try {
            MessageConsumer mc = this.session.createConsumer(destination, selector);
            if (mc != null && listeners != null) {
                for (MessageListener listener : listeners) {
                    try {
                        mc.setMessageListener(listener);
                    }
                    catch (JMSException e) {
                        this.logger.warn((Object)("Unable to map listener " + listener + " to consumer " + mc), (Throwable)e);
                    }
                }
            }
            return mc;
        }
        catch (JMSException e) {
            this.logger.warn((Object)"Unable to create message consumer", (Throwable)e);
            return null;
        }
    }

    protected MessageConsumer createMessageConsumer(Destination destination) {
        try {
            return this.session.createConsumer(destination);
        }
        catch (JMSException e) {
            this.logger.warn((Object)("Problem creating message consumer for " + destination), (Throwable)e);
            return null;
        }
    }

    protected MessageProducer createMessageProducer(Destination destination) {
        try {
            return this.session.createProducer(destination);
        }
        catch (JMSException e) {
            this.logger.warn((Object)("Problem creating message producer for " + destination), (Throwable)e);
            return null;
        }
    }

    private TopicSubscriber createDurableSubscriber(String destination, String id) {
        try {
            return this.session.createDurableSubscriber((Topic)this.lookupDestination(destination), id);
        }
        catch (JMSException e) {
            this.logger.warn((Object)"Unable to create durable subscriber", (Throwable)e);
            return null;
        }
    }

    public MessageProducer createMessageProducer(String destination) {
        try {
            return this.session.createProducer(this.lookupDestination(destination));
        }
        catch (JMSException e) {
            this.logger.warn((Object)"Unable to create message producer", (Throwable)e);
            return null;
        }
    }

    public TopicPublisher createTopicPublisher(String destination) {
        return (TopicPublisher)this.createMessageProducer(destination);
    }

    public QueueSender createQueueSender(String destination) {
        return (QueueSender)this.createMessageProducer(destination);
    }

    public TopicSubscriber createTopicSubscriber(String destination, MessageListener ... listeners) {
        MessageConsumer mc = this.createMessageConsumer(destination, listeners);
        return (TopicSubscriber)mc;
    }

    public TopicSubscriber createTopicSubscriber(String destination, String selector, MessageListener ... listeners) {
        return (TopicSubscriber)this.createMessageConsumer(destination, selector, listeners);
    }

    public TopicSubscriber createTopicSubscriber(Destination destination, String selector, MessageListener ... listeners) {
        return (TopicSubscriber)this.createMessageConsumer(destination, selector, listeners);
    }

    public QueueReceiver createQueueReceiver(String destination, MessageListener ... listeners) {
        MessageConsumer mc = this.createMessageConsumer(destination, listeners);
        return (QueueReceiver)mc;
    }

    public MessageConsumer createMessageConsumer(Destination destination, MessageListener ... listeners) {
        MessageConsumer mc = this.createMessageConsumer(destination);
        if (mc != null && listeners != null) {
            for (MessageListener listener : listeners) {
                try {
                    mc.setMessageListener(listener);
                }
                catch (JMSException e) {
                    this.logger.warn((Object)("Unable to set listener " + listener + " on to destination " + destination));
                }
            }
        }
        return mc;
    }

    public TopicBuilder createTopicBuilder() {
        return new TopicBuilderImpl(this.exceptionEvent);
    }

    public QueueBuilder createQueueBuilder() {
        return new QueueBuilderImpl(this.exceptionEvent);
    }

    public JmsMessage createJmsMessage(Class<?> payloadType, Object payload) {
        return new JmsMessageImpl(payloadType, payload, this);
    }

    public TopicPublisher createTopicPublisher(Topic topic) {
        return (TopicPublisher)this.createMessageProducer((Destination)topic);
    }

    public QueueSender createQueueSender(Queue queue) {
        return (QueueSender)this.createMessageProducer((Destination)queue);
    }
}

