/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.jms;

import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import javax.enterprise.event.Event;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.jboss.seam.jms.QueueBuilder;
import org.jboss.solder.exception.control.ExceptionToCatch;
import org.jboss.solder.logging.Logger;

public class QueueBuilderImpl
implements QueueBuilder {
    private Logger logger = Logger.getLogger(QueueBuilderImpl.class);
    private Event<ExceptionToCatch> exceptionEvent;
    private ConnectionFactory connectionFactory;
    private Connection connection;
    private Session session;
    private MessageProducer messageProducer;
    private MessageConsumer messageConsumer;
    private Queue lastQueue;
    private boolean transacted = false;
    private int sessionMode = 1;

    QueueBuilderImpl(Event<ExceptionToCatch> exceptionEvent) {
        this.exceptionEvent = exceptionEvent;
    }

    public QueueBuilder destination(Queue queue) {
        this.lastQueue = queue;
        this.cleanupMessaging();
        this.messageProducer = null;
        this.messageConsumer = null;
        return this;
    }

    private void cleanupMessaging() {
        try {
            if (this.messageConsumer != null) {
                this.messageConsumer.close();
            }
            if (this.messageProducer != null) {
                this.messageProducer.close();
            }
            this.messageConsumer = null;
            this.messageProducer = null;
        }
        catch (JMSException ex) {
            this.logger.error((Object)"unable to create queuebuilder, ", (Throwable)ex);
            this.exceptionEvent.fire((Object)new ExceptionToCatch((Throwable)ex));
        }
    }

    private void cleanConnection() {
        try {
            if (this.session != null) {
                this.session.close();
            }
            if (this.connection != null) {
                this.connection.close();
            }
            this.session = null;
            this.connection = null;
            this.cleanupMessaging();
        }
        catch (JMSException ex) {
            this.exceptionEvent.fire((Object)new ExceptionToCatch((Throwable)ex));
        }
    }

    private void createMessageProducer() {
        if (this.messageProducer == null) {
            try {
                this.messageProducer = this.session.createProducer((Destination)this.lastQueue);
            }
            catch (JMSException ex) {
                this.exceptionEvent.fire((Object)new ExceptionToCatch((Throwable)ex));
            }
        }
    }

    private void createMessageConsumer() {
        if (this.messageConsumer == null) {
            try {
                this.messageConsumer = this.session.createConsumer((Destination)this.lastQueue);
            }
            catch (JMSException ex) {
                this.exceptionEvent.fire((Object)new ExceptionToCatch((Throwable)ex));
            }
        }
    }

    public QueueBuilder connectionFactory(ConnectionFactory cf) {
        try {
            this.cleanConnection();
            this.connectionFactory = cf;
            this.connection = cf.createConnection();
            this.session = this.connection.createSession(this.transacted, this.sessionMode);
            this.logger.debug((Object)("Created session  " + this.session));
            this.connection.start();
            return this;
        }
        catch (JMSException ex) {
            this.exceptionEvent.fire((Object)new ExceptionToCatch((Throwable)ex));
            return null;
        }
    }

    public QueueBuilder send(Message m) {
        this.createMessageProducer();
        try {
            this.messageProducer.send(m);
        }
        catch (JMSException ex) {
            this.exceptionEvent.fire((Object)new ExceptionToCatch((Throwable)ex));
        }
        return this;
    }

    public QueueBuilder sendMap(Map map) {
        try {
            MapMessage msg = this.session.createMapMessage();
            Set keys = map.keySet();
            for (Object key : keys) {
                Object value = map.get(key);
                msg.setObject(key.toString(), value);
            }
            this.send((Message)msg);
        }
        catch (JMSException ex) {
            this.exceptionEvent.fire((Object)new ExceptionToCatch((Throwable)ex));
        }
        return this;
    }

    public QueueBuilder sendString(String string) {
        try {
            TextMessage tm = this.session.createTextMessage();
            tm.setText(string);
            this.send((Message)tm);
        }
        catch (JMSException ex) {
            this.exceptionEvent.fire((Object)new ExceptionToCatch((Throwable)ex));
        }
        return this;
    }

    public QueueBuilder sendObject(Serializable obj) {
        try {
            ObjectMessage om = this.session.createObjectMessage();
            om.setObject(obj);
            this.send((Message)om);
        }
        catch (JMSException ex) {
            this.exceptionEvent.fire((Object)new ExceptionToCatch((Throwable)ex));
        }
        return this;
    }

    public QueueBuilder listen(MessageListener listener) {
        this.createMessageConsumer();
        try {
            this.messageConsumer.setMessageListener(listener);
        }
        catch (JMSException ex) {
            this.exceptionEvent.fire((Object)new ExceptionToCatch((Throwable)ex));
        }
        return this;
    }

    public QueueBuilder newBuilder() {
        return new QueueBuilderImpl(this.exceptionEvent);
    }

    public QueueBuilder transacted() {
        this.transacted = !this.transacted;
        return this;
    }

    public QueueBuilder sessionMode(int sessionMode) {
        this.sessionMode = sessionMode;
        return this;
    }

    public QueueBrowser getQueueBrowser() {
        try {
            return this.session.createBrowser(this.lastQueue);
        }
        catch (JMSException ex) {
            this.exceptionEvent.fire((Object)new ExceptionToCatch((Throwable)ex));
            return null;
        }
    }
}

