/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.jms;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ObserverMethod;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.inject.Qualifier;
import javax.jms.Destination;
import org.jboss.seam.jms.annotations.EventRouting;
import org.jboss.seam.jms.annotations.Inbound;
import org.jboss.seam.jms.annotations.Outbound;
import org.jboss.seam.jms.annotations.Routing;
import org.jboss.seam.jms.bridge.EgressRoutingObserver;
import org.jboss.seam.jms.bridge.Route;
import org.jboss.seam.jms.bridge.RouteImpl;
import org.jboss.seam.jms.bridge.RouteManagerImpl;
import org.jboss.seam.jms.bridge.RouteType;
import org.jboss.solder.core.VersionLoggerUtil;
import org.jboss.solder.logging.Logger;

public class Seam3JmsExtension
implements Extension {
    private static final Logger log = Logger.getLogger(Seam3JmsExtension.class);
    private List<Route> ingressRoutes = new ArrayList<Route>();
    private List<Route> egressRoutes = new ArrayList<Route>();
    private List<EgressRoutingObserver> observerMethods = new ArrayList<EgressRoutingObserver>();
    private Set<AnnotatedType<?>> eventRoutingRegistry = new HashSet();
    private Set<AnnotatedMethod<?>> observerMethodRegistry = new HashSet();
    private boolean readyToRoute = false;

    public void buildRoutes(@Observes AfterBeanDiscovery abd, BeanManager bm) {
        log.debug((Object)"Building JMS Routes.");
        RouteManagerImpl routeManager = new RouteManagerImpl();
        for (AnnotatedType<?> annotatedType : this.eventRoutingRegistry) {
            Object instance = null;
            try {
                instance = annotatedType.getJavaClass().newInstance();
            }
            catch (InstantiationException ex) {
                abd.addDefinitionError((Throwable)ex);
                break;
            }
            catch (IllegalAccessException ex) {
                abd.addDefinitionError((Throwable)ex);
                break;
            }
            for (AnnotatedMethod am : annotatedType.getMethods()) {
                Object result = null;
                try {
                    result = am.getJavaMember().invoke(instance, routeManager);
                }
                catch (IllegalAccessException ex) {
                    abd.addDefinitionError((Throwable)ex);
                }
                catch (IllegalArgumentException ex) {
                    abd.addDefinitionError((Throwable)ex);
                }
                catch (InvocationTargetException ex) {
                    abd.addDefinitionError((Throwable)ex);
                }
                if (result == null) continue;
                if (Collection.class.isAssignableFrom(result.getClass())) {
                    Collection routes = (Collection)Collection.class.cast(result);
                    for (Route route : routes) {
                        if (route == null) {
                            log.warn((Object)("No routes found for " + am));
                            continue;
                        }
                        this.addRoute(route);
                    }
                    continue;
                }
                if (Route.class.isAssignableFrom(result.getClass())) {
                    this.addRoute((Route)Route.class.cast(result));
                    continue;
                }
                abd.addDefinitionError((Throwable)new IllegalArgumentException("Unsupported route configuration type: " + result));
            }
        }
        for (AnnotatedMethod annotatedMethod : this.observerMethodRegistry) {
            for (AnnotatedParameter ap : annotatedMethod.getParameters()) {
                log.debug((Object)("In method " + annotatedMethod.getJavaMember().getName() + " with param type " + ap.getBaseType()));
            }
            Class<?> intfClazz = annotatedMethod.getJavaMember().getDeclaringClass();
            String methodName = annotatedMethod.getJavaMember().getName();
            String routeId = intfClazz.getCanonicalName() + "." + methodName;
            RouteType routeType = null;
            if (annotatedMethod.isAnnotationPresent(Inbound.class)) {
                routeType = RouteType.INGRESS;
            } else if (annotatedMethod.isAnnotationPresent(Outbound.class)) {
                routeType = RouteType.EGRESS;
            } else if (annotatedMethod.isAnnotationPresent(Routing.class)) {
                Routing routing = (Routing)annotatedMethod.getAnnotation(Routing.class);
                routeType = routing.value();
            } else {
                log.debug((Object)("Routing not found on method " + annotatedMethod.getJavaMember().getName()));
                routeType = RouteType.BOTH;
            }
            Route route = new RouteImpl(routeType).id(routeId);
            boolean isResourced = annotatedMethod.isAnnotationPresent(Resource.class);
            if (isResourced) {
                Resource r = (Resource)annotatedMethod.getAnnotation(Resource.class);
                log.debug((Object)("Loading resource " + r.mappedName()));
                route.addDestinationJndiName(r.mappedName());
            }
            try {
                for (AnnotatedParameter ap : annotatedMethod.getParameters()) {
                    if (!(ap.getBaseType() instanceof Class)) continue;
                    Class clazz = (Class)ap.getBaseType();
                    if (Destination.class.isAssignableFrom(clazz)) {
                        log.debug((Object)"Found another type of qualifier.");
                        route.addAnnotatedParameter(ap);
                        continue;
                    }
                    if (!ap.isAnnotationPresent(Observes.class)) continue;
                    route.setType(ap.getBaseType());
                    route.getQualifiers().addAll(Seam3JmsExtension.getQualifiersFrom(ap.getAnnotations()));
                }
            }
            catch (Exception e) {
                log.warn((Object)("Exception mapping for method " + annotatedMethod.getJavaMember().getDeclaringClass() + "." + annotatedMethod.getJavaMember().getName() + ", "), (Throwable)e);
            }
            this.addRoute(route);
        }
        for (Route route : this.egressRoutes) {
            EgressRoutingObserver ero = new EgressRoutingObserver(route, this);
            abd.addObserverMethod((ObserverMethod)ero);
            this.observerMethods.add(ero);
        }
    }

    public void setBeanManager(BeanManager beanManager) {
        log.debug((Object)"Handling AfterDeploymentValidation, loading active bean manager into all beans.");
        VersionLoggerUtil.logVersionInformation(this.getClass());
        if (!this.readyToRoute) {
            for (EgressRoutingObserver ero : this.observerMethods) {
                log.debug((Object)("Setting observer method beanmanager. " + beanManager));
                ero.setBeanManager(beanManager);
            }
            this.readyToRoute = true;
        }
        log.debug((Object)("EgressRoutingObservers: " + this.observerMethods));
        log.debug((Object)("Ingress routes: " + this.ingressRoutes));
    }

    public boolean isReadyToRoute() {
        return this.readyToRoute;
    }

    public void registerObserverMethods(@Observes ProcessAnnotatedType<?> pat) {
        if (pat.getAnnotatedType().getJavaClass().isInterface()) {
            log.debug((Object)("Found a possible interface... " + pat.getAnnotatedType().getJavaClass()));
            for (AnnotatedMethod m : pat.getAnnotatedType().getMethods()) {
                this.observerMethodRegistry.add(m);
            }
        } else {
            HashSet<AnnotatedMethod> sams = new HashSet<AnnotatedMethod>();
            for (AnnotatedMethod m : pat.getAnnotatedType().getMethods()) {
                if (!m.isAnnotationPresent(EventRouting.class)) continue;
                sams.add(m);
            }
            if (!sams.isEmpty()) {
                pat.veto();
                this.eventRoutingRegistry.add(pat.getAnnotatedType());
            }
        }
    }

    private void addRoute(Route route) {
        log.debug((Object)("RouteType is: " + route.getType()));
        if (route.validate()) {
            if (route.getType() == RouteType.EGRESS) {
                this.egressRoutes.add(route);
            } else if (route.getType() == RouteType.INGRESS) {
                this.ingressRoutes.add(route);
            } else {
                log.debug((Object)"Adding both types of routes.");
                this.egressRoutes.add(route);
                this.ingressRoutes.add(route);
            }
        } else {
            log.debugf("Not adding route %s to routes, it was not valid.", (Object)route);
        }
    }

    public List<Route> getIngressRoutes() {
        return this.ingressRoutes;
    }

    public List<Route> getEgressRoutes() {
        return this.egressRoutes;
    }

    private static Set<Annotation> getQualifiersFrom(Set<Annotation> annotations) {
        HashSet<Annotation> q = new HashSet<Annotation>();
        log.debug((Object)("Annotations in getQualifiersFrom: " + annotations));
        for (Annotation a : annotations) {
            if (a.annotationType().isAnnotationPresent(Qualifier.class)) {
                q.add(a);
                continue;
            }
            log.infof("Skipping annotation %s", (Object)a);
        }
        return q;
    }
}

