/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.jms;

import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import javax.enterprise.event.Event;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import org.jboss.seam.jms.TopicBuilder;
import org.jboss.solder.exception.control.ExceptionToCatch;
import org.jboss.solder.logging.Logger;

public class TopicBuilderImpl
implements TopicBuilder {
    private Logger logger = Logger.getLogger(TopicBuilder.class);
    private Event<ExceptionToCatch> exceptionEvent;
    private ConnectionFactory connectionFactory;
    private Connection connection;
    private Session session;
    private MessageProducer messageProducer;
    private MessageConsumer messageConsumer;
    private Topic lastTopic;
    private boolean transacted = false;
    private int sessionMode = 1;
    private String subtopic;

    TopicBuilderImpl(Event<ExceptionToCatch> event) {
        this.exceptionEvent = event;
    }

    public TopicBuilder destination(Topic topic) {
        this.lastTopic = topic;
        this.messageProducer = null;
        this.messageConsumer = null;
        return this;
    }

    private void cleanupMessaging() {
        try {
            if (this.messageConsumer != null) {
                this.messageConsumer.close();
            }
            if (this.messageProducer != null) {
                this.messageProducer.close();
            }
            this.messageConsumer = null;
            this.messageProducer = null;
        }
        catch (JMSException ex) {
            this.logger.error((Object)"There was a problem cleaning up the JMS session", (Throwable)ex);
            this.exceptionEvent.fire((Object)new ExceptionToCatch((Throwable)ex));
        }
    }

    private void cleanConnection() {
        try {
            if (this.session != null) {
                this.session.close();
            }
            if (this.connection != null) {
                this.connection.close();
            }
            this.session = null;
            this.connection = null;
            this.cleanupMessaging();
        }
        catch (JMSException ex) {
            this.logger.error((Object)"There was a problem cleaning up the JMS connection", (Throwable)ex);
            this.exceptionEvent.fire((Object)new ExceptionToCatch((Throwable)ex));
        }
    }

    private void createMessageProducer() {
        this.logger.debug((Object)"Creating the MessageProducer.");
        if (this.messageProducer == null) {
            try {
                this.messageProducer = this.session.createProducer((Destination)this.lastTopic);
            }
            catch (JMSException ex) {
                this.logger.error((Object)"There was a problem creating the MessageProducer", (Throwable)ex);
                this.exceptionEvent.fire((Object)new ExceptionToCatch((Throwable)ex));
            }
        }
    }

    public void close() {
        this.cleanMessageProducer();
    }

    private void cleanMessageProducer() {
        if (this.messageProducer != null) {
            try {
                this.messageProducer.close();
            }
            catch (JMSException ex) {
                this.logger.error((Object)"Unable to close producer", (Throwable)ex);
                this.exceptionEvent.fire((Object)new ExceptionToCatch((Throwable)ex));
            }
        }
    }

    private void createMessageConsumer() {
        this.logger.debug((Object)"Creating the MessageConsumer.");
        if (this.messageConsumer == null) {
            try {
                this.logger.debug((Object)"ABout to create.");
                this.messageConsumer = this.session.createConsumer((Destination)this.lastTopic);
            }
            catch (JMSException ex) {
                this.logger.error((Object)"There was a problem creating the MessageConsumer", (Throwable)ex);
                this.exceptionEvent.fire((Object)new ExceptionToCatch((Throwable)ex));
            }
        } else {
            this.logger.debug((Object)"messageConsumer is not null, not creating a new one");
        }
    }

    public TopicBuilder connectionFactory(ConnectionFactory cf) {
        try {
            this.cleanConnection();
            this.connectionFactory = cf;
            this.connection = cf.createConnection();
            this.session = this.connection.createSession(this.transacted, this.sessionMode);
            this.connection.start();
            return this;
        }
        catch (JMSException ex) {
            this.logger.error((Object)"Unable to set connection factory", (Throwable)ex);
            this.exceptionEvent.fire((Object)new ExceptionToCatch((Throwable)ex));
            return null;
        }
    }

    public TopicBuilder send(Message m) {
        this.createMessageProducer();
        try {
            this.messageProducer.send(m);
        }
        catch (JMSException ex) {
            this.exceptionEvent.fire((Object)new ExceptionToCatch((Throwable)ex));
        }
        return this;
    }

    public TopicBuilder subtopic(String subtopic) {
        this.subtopic = subtopic;
        return this;
    }

    public TopicBuilder sendMap(Map map) {
        try {
            Session s = this.session;
            MapMessage msg = s.createMapMessage();
            Set keys = map.keySet();
            for (Object key : keys) {
                Object value = map.get(key);
                msg.setObject(key.toString(), value);
            }
            this.send((Message)msg);
        }
        catch (JMSException ex) {
            this.exceptionEvent.fire((Object)new ExceptionToCatch((Throwable)ex));
        }
        return this;
    }

    public TopicBuilder sendString(String string) {
        this.logger.debug((Object)("Sending a string. " + string));
        try {
            Session s = this.session;
            TextMessage tm = s.createTextMessage();
            tm.setText(string);
            this.send((Message)tm);
        }
        catch (JMSException ex) {
            this.logger.error((Object)"There was a problem sending the String", (Throwable)ex);
            this.exceptionEvent.fire((Object)new ExceptionToCatch((Throwable)ex));
        }
        return this;
    }

    public TopicBuilder sendObject(Serializable obj) {
        this.logger.debug((Object)("Sending an object. " + obj));
        try {
            Session s = this.session;
            ObjectMessage om = s.createObjectMessage();
            om.setObject(obj);
            this.send((Message)om);
        }
        catch (JMSException ex) {
            this.logger.error((Object)"There was a problem sending the Object", (Throwable)ex);
            this.exceptionEvent.fire((Object)new ExceptionToCatch((Throwable)ex));
        }
        return this;
    }

    public TopicBuilder listen(MessageListener listener) {
        this.logger.debug((Object)"Setting up a message listener.");
        this.createMessageConsumer();
        try {
            this.messageConsumer.setMessageListener(listener);
        }
        catch (JMSException ex) {
            this.exceptionEvent.fire((Object)new ExceptionToCatch((Throwable)ex));
        }
        return this;
    }

    public TopicBuilder newBuilder() {
        return new TopicBuilderImpl(this.exceptionEvent);
    }

    public String getSubtopic() {
        return this.subtopic;
    }

    public TopicBuilder transacted() {
        this.transacted = !this.transacted;
        return this;
    }

    public TopicBuilder sessionMode(int sessionMode) {
        this.sessionMode = sessionMode;
        return this;
    }
}

