/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.jms.bridge;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.event.Reception;
import javax.enterprise.event.TransactionPhase;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.ObserverMethod;
import javax.jms.Destination;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.seam.jms.MessageManager;
import org.jboss.seam.jms.Seam3JmsExtension;
import org.jboss.seam.jms.annotations.OutboundLiteral;
import org.jboss.seam.jms.annotations.RoutingLiteral;
import org.jboss.seam.jms.bridge.Route;
import org.jboss.solder.bean.ImmutableInjectionPoint;
import org.jboss.solder.core.Veto;
import org.jboss.solder.logging.Logger;

@Veto
public class EgressRoutingObserver
implements ObserverMethod<Object> {
    private Logger log;
    private BeanManager bm;
    private Route route;
    private Seam3JmsExtension extension;
    private List<Object> evtCache = new ArrayList<Object>();

    public EgressRoutingObserver(BeanManager bm, Route routing, Seam3JmsExtension extension) {
        this(routing, extension);
        this.bm = bm;
    }

    public EgressRoutingObserver(Route route, Seam3JmsExtension extension) {
        this.route = route;
        this.extension = extension;
        this.log = Logger.getLogger(EgressRoutingObserver.class);
    }

    public void setBeanManager(BeanManager beanManager) {
        this.bm = beanManager;
        this.loadDestinations();
    }

    public Class<?> getBeanClass() {
        return this.getClass();
    }

    public Set<Annotation> getObservedQualifiers() {
        HashSet<Object> as = new HashSet<Object>();
        as.addAll(this.route.getQualifiers());
        as.add(RoutingLiteral.EGRESS);
        as.add((Object)OutboundLiteral.INSTANCE);
        this.log.debugf("Inidicating that I observe these qualifiers: [%s]", as);
        return this.route.getQualifiers();
    }

    public Type getObservedType() {
        return this.route.getPayloadType();
    }

    public Reception getReception() {
        return Reception.ALWAYS;
    }

    public TransactionPhase getTransactionPhase() {
        return TransactionPhase.AFTER_SUCCESS;
    }

    public void notify(Object evt) {
        this.log.debugf("Notified of an event: %s", evt);
        if (this.extension.isReadyToRoute()) {
            this.forwardEvent(evt);
        } else {
            this.log.warn((Object)("Adding event to evt cache " + evt));
            this.evtCache.add(evt);
        }
    }

    private MessageManager getMessageBuilder() {
        Set beans = this.bm.getBeans(MessageManager.class, new Annotation[0]);
        Bean bean = this.bm.resolve(beans);
        MessageManager mb = (MessageManager)this.bm.getReference(bean, MessageManager.class, this.bm.createCreationalContext((Contextual)bean));
        return mb;
    }

    private void loadDestinations() {
        Destination destination;
        HashSet<Destination> destinations = new HashSet<Destination>();
        destinations.addAll(this.route.getDestinations());
        for (String dest : this.route.getDestinationJndiNames()) {
            destination = this.lookupDestination(dest);
            destinations.add(destination);
        }
        for (AnnotatedParameter ap : this.route.getAnnotatedParameters()) {
            destination = this.lookupDestination(ap);
            destinations.add(destination);
        }
        this.log.infof("Routing destinations: [%s]", destinations);
        this.route.setDestinations(destinations);
    }

    private Destination lookupDestination(String jndiName) {
        try {
            InitialContext c = new InitialContext();
            return (Destination)c.lookup(jndiName);
        }
        catch (NamingException e) {
            this.log.warn((Object)("Unable to lookup " + jndiName), (Throwable)e);
            return null;
        }
    }

    private Destination lookupDestination(AnnotatedParameter<?> ap) {
        this.log.debug((Object)("Looking up destination: " + ap));
        Set beans = this.bm.getBeans(Destination.class, new Annotation[0]);
        Bean bean = this.bm.resolve(beans);
        ImmutableInjectionPoint iip = new ImmutableInjectionPoint(ap, this.bm, bean, false, false);
        Object o = this.bm.getInjectableReference((InjectionPoint)iip, this.bm.createCreationalContext((Contextual)bean));
        return (Destination)o;
    }

    private void forwardEvent(Object event) {
        if (!this.route.isEgressEnabled()) {
            return;
        }
        MessageManager msgBuilder = this.getMessageBuilder();
        if (event instanceof String) {
            msgBuilder.sendTextToDestinations(event.toString(), this.route.getDestinations().toArray(new Destination[0]));
        } else {
            msgBuilder.sendObjectToDestinations(event, this.route.getDestinations().toArray(new Destination[0]));
        }
    }
}

