/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.jms.bridge;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import javax.enterprise.inject.spi.BeanManager;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.TextMessage;
import org.jboss.seam.jms.AbstractMessageListener;
import org.jboss.seam.jms.annotations.InboundLiteral;
import org.jboss.seam.jms.annotations.RoutingLiteral;
import org.jboss.seam.jms.bridge.Route;
import org.jboss.solder.logging.Logger;

public class IngressMessageListener
extends AbstractMessageListener {
    private Annotation[] qualifiers = null;
    private Logger logger = Logger.getLogger(IngressMessageListener.class);
    private Class<?> payload;
    private Route route;

    public IngressMessageListener(BeanManager beanManager, ClassLoader classLoader, Route route) {
        super(beanManager, classLoader);
        this.logger.debug((Object)"Creating new IngressMessageListener.");
        this.setRoute(route);
    }

    public void setRoute(Route route) {
        this.logger.info((Object)("Setting route. " + route));
        HashSet<Object> annotations = new HashSet<Object>();
        if (!route.getQualifiers().isEmpty()) {
            annotations.addAll(route.getQualifiers());
        }
        this.payload = (Class)route.getPayloadType();
        annotations.add(RoutingLiteral.INGRESS);
        annotations.add((Object)InboundLiteral.INSTANCE);
        this.logger.info((Object)("Qualifiers: " + annotations));
        this.qualifiers = annotations.toArray(new Annotation[0]);
        this.route = route;
    }

    private boolean isMessagePayload() {
        return this.payload.isAssignableFrom(Message.class);
    }

    protected void handleMessage(Message msg) throws JMSException {
        if (!this.route.isIngressEnabled()) {
            return;
        }
        if (this.isMessagePayload()) {
            this.beanManager.fireEvent((Object)msg, this.qualifiers);
        } else if (msg instanceof ObjectMessage) {
            ObjectMessage om = (ObjectMessage)msg;
            try {
                Serializable data = om.getObject();
                this.logger.debug((Object)("data was: " + om.getObject() + " of type " + data.getClass().getCanonicalName()));
                this.beanManager.fireEvent((Object)data, this.qualifiers);
            }
            catch (JMSException ex) {
                this.logger.warn((Object)("Unable to read data in message " + msg));
            }
        } else if (msg instanceof TextMessage && this.payload.isAssignableFrom(String.class)) {
            TextMessage tm = (TextMessage)msg;
            try {
                String data = tm.getText();
                this.logger.debug((Object)("data was: " + data + " of type " + data.getClass().getCanonicalName()));
                this.beanManager.fireEvent((Object)data, this.qualifiers);
            }
            catch (JMSException e) {
                this.logger.warn((Object)("Unable to read data in message " + msg));
            }
        } else {
            this.logger.warn((Object)("Received the wrong type of message " + msg));
        }
    }
}

