/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.jms.bridge;

import java.util.Map;
import java.util.Set;
import javax.enterprise.event.Observes;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;
import org.jboss.seam.jms.JmsMessage;
import org.jboss.seam.jms.MessageManager;
import org.jboss.solder.logging.Logger;

public class JmsMessageObserver {
    private Logger logger = Logger.getLogger(JmsMessageObserver.class);

    public void observeJmsMessages(@Observes JmsMessage jmsMessage, MessageManager messageManager) throws JMSException {
        TextMessage msg = null;
        Class payloadType = jmsMessage.getPayloadType();
        if (payloadType.isAssignableFrom(String.class)) {
            String data = (String)jmsMessage.getPayload();
            msg = messageManager.createTextMessage(data);
        } else if (payloadType.isAssignableFrom(Map.class)) {
            Map map = (Map)jmsMessage.getPayload();
            msg = messageManager.createMapMessage(map);
        } else {
            msg = messageManager.createObjectMessage(jmsMessage.getPayload());
        }
        Map properties = jmsMessage.getProperties();
        Set propKeys = properties.keySet();
        for (String key : propKeys) {
            Object value = properties.get(key);
            Class<Object> type = value.getClass();
            if (type.isAssignableFrom(Boolean.class)) {
                msg.setBooleanProperty(key, ((Boolean)value).booleanValue());
                continue;
            }
            if (type.isAssignableFrom(Byte.class)) {
                msg.setByteProperty(key, ((Byte)value).byteValue());
                continue;
            }
            if (type.isAssignableFrom(Double.class)) {
                msg.setDoubleProperty(key, ((Double)value).doubleValue());
                continue;
            }
            if (type.isAssignableFrom(Float.class)) {
                msg.setFloatProperty(key, ((Float)value).floatValue());
                continue;
            }
            if (type.isAssignableFrom(Integer.class)) {
                msg.setIntProperty(key, ((Integer)value).intValue());
                continue;
            }
            if (type.isAssignableFrom(Long.class)) {
                msg.setLongProperty(key, ((Long)value).longValue());
                continue;
            }
            if (type.isAssignableFrom(Short.class)) {
                msg.setShortProperty(key, ((Short)value).shortValue());
                continue;
            }
            if (type.isAssignableFrom(String.class)) {
                msg.setStringProperty(key, (String)value);
                continue;
            }
            msg.setObjectProperty(key, value);
        }
        Map headers = jmsMessage.getHeaders();
        Set headerKeys = headers.keySet();
        for (String key : headerKeys) {
            Object value = headers.get(key);
            if (key.equalsIgnoreCase("JMSCorrelationID")) {
                msg.setJMSCorrelationID(value.toString());
                continue;
            }
            if (key.equalsIgnoreCase("JMSDeliveryMode")) {
                msg.setJMSDeliveryMode(((Integer)value).intValue());
                continue;
            }
            if (key.equalsIgnoreCase("JMSExpiration")) {
                msg.setJMSExpiration(((Long)value).longValue());
                continue;
            }
            if (key.equalsIgnoreCase("JMSMessageID")) {
                msg.setJMSMessageID(value.toString());
                continue;
            }
            if (key.equalsIgnoreCase("JMSPriority")) {
                msg.setJMSPriority(((Integer)value).intValue());
                continue;
            }
            if (key.equalsIgnoreCase("JMSRedelivered")) {
                msg.setJMSRedelivered(((Boolean)value).booleanValue());
                continue;
            }
            if (key.equalsIgnoreCase("JMSTimestamp")) {
                msg.setJMSTimestamp(((Long)value).longValue());
                continue;
            }
            if (key.equalsIgnoreCase("JMSType")) {
                msg.setJMSType(value.toString());
                continue;
            }
            this.logger.warnf("Unable to set header %s on message with value %s", (Object)key, value);
        }
        Destination[] destinations = jmsMessage.getDestinations().toArray(new Destination[0]);
        messageManager.sendMessage((Message)msg, destinations);
    }
}

