/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.jms.bridge;

import java.io.Serializable;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageListener;
import javax.servlet.ServletContext;
import org.jboss.seam.jms.MessageManager;
import org.jboss.seam.jms.Seam3JmsExtension;
import org.jboss.seam.jms.bridge.IngressMessageListener;
import org.jboss.seam.jms.bridge.Route;
import org.jboss.seam.jms.bridge.RouteBuilder;
import org.jboss.solder.logging.Logger;

@Singleton
public class RouteBuilderImpl
implements RouteBuilder,
Serializable {
    private static final long serialVersionUID = -6782656668733696386L;
    private Logger log = Logger.getLogger(RouteBuilderImpl.class);
    private List<Route> ingressRoutes;
    @Inject
    Seam3JmsExtension extension;
    @Inject
    MessageManager messageBuilder;
    @Inject
    BeanManager beanManager;

    public void handleStartup(@Observes ServletContext servletContext) {
        this.log.debug((Object)"Starting up Seam JMS via ServletContext callback.");
    }

    @PostConstruct
    public void init() throws JMSException {
        this.log.debug((Object)"Calling RouteBuilder.init");
        this.extension.setBeanManager(this.beanManager);
        this.ingressRoutes = this.extension.getIngressRoutes();
        this.log.debug((Object)("Ingress routes size: (" + this.ingressRoutes.size() + ") " + this.ingressRoutes));
        for (Route ingressRoute : this.ingressRoutes) {
            ingressRoute.build(this.beanManager);
            this.createListener(ingressRoute);
        }
    }

    private void createListener(Route ingressRoute) {
        ClassLoader prevCl = Thread.currentThread().getContextClassLoader();
        this.log.debug((Object)("About to create listener for route " + ingressRoute));
        this.log.debug((Object)("Routes: " + ingressRoute.getDestinations()));
        for (Destination d : ingressRoute.getDestinations()) {
            IngressMessageListener listener = new IngressMessageListener(this.beanManager, prevCl, ingressRoute);
            this.messageBuilder.createMessageConsumer(d, new MessageListener[]{listener});
        }
    }
}

