/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.jms.bridge;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Qualifier;
import javax.jms.Destination;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.seam.jms.bridge.Route;
import org.jboss.seam.jms.bridge.RouteType;
import org.jboss.solder.bean.ImmutableInjectionPoint;
import org.jboss.solder.logging.Logger;

public class RouteImpl
implements Route {
    private RouteType type;
    private String id;
    private Type payloadType;
    private Set<Annotation> qualifiers;
    private Set<Destination> destinations;
    private List<Set<Annotation>> destinationQualifiers;
    private Set<String> destinationJndiNames;
    private Set<AnnotatedParameter<?>> annotatedParameters;
    private Logger logger = Logger.getLogger(RouteImpl.class);
    private boolean built = false;
    private BeanManager bm;
    private boolean egressEnabled = false;
    private boolean ingressEnabled = false;

    public RouteImpl(RouteType type, Type payloadType) {
        this(type);
        this.payloadType = payloadType;
    }

    public RouteImpl(RouteType type) {
        this.type = type;
        this.enableEgress();
        this.enableIngress();
        this.qualifiers = new HashSet<Annotation>();
        this.destinations = new HashSet<Destination>();
        this.destinationQualifiers = new ArrayList<Set<Annotation>>();
        this.destinationJndiNames = new HashSet<String>();
        this.annotatedParameters = new HashSet();
    }

    public Route addQualifiers(Collection<Annotation> q) {
        if (q != null) {
            for (Annotation qualifier : q) {
                if (!qualifier.annotationType().isAnnotationPresent(Qualifier.class)) {
                    throw new IllegalArgumentException("not a qualifier: " + qualifier);
                }
                this.qualifiers.add(qualifier);
            }
        }
        return this;
    }

    public Route addQualifiers(Annotation ... q) {
        return this.addQualifiers(Arrays.asList(q));
    }

    public Route addDestinations(Destination ... d) {
        return this.addDestinations(Arrays.asList(d));
    }

    public Route addDestinations(Collection<Destination> d) {
        this.destinations.addAll(d);
        return this;
    }

    public <D extends Destination> Route connectTo(Class<D> d, D destination) {
        this.destinations.add((Destination)Destination.class.cast(destination));
        return this;
    }

    public Route addDestinationQualifiers(Set<Annotation> qualifiers) {
        this.destinationQualifiers.add(qualifiers);
        return this;
    }

    public Route addDestinationJndiName(String jndi) {
        this.destinationJndiNames.add(jndi);
        return this;
    }

    public RouteType getType() {
        return this.type;
    }

    public Type getPayloadType() {
        return this.payloadType;
    }

    public Set<Annotation> getQualifiers() {
        return this.qualifiers;
    }

    public Set<? extends Destination> getDestinations() {
        return this.destinations;
    }

    public Set<String> getDestinationJndiNames() {
        return this.destinationJndiNames;
    }

    public List<Set<Annotation>> getDestinationQualifiers() {
        return this.destinationQualifiers;
    }

    public Route addAnnotatedParameter(AnnotatedParameter<?> ap) {
        this.annotatedParameters.add(ap);
        return this;
    }

    public void build(BeanManager beanManager) {
        if (!this.built) {
            this.bm = beanManager;
            this.loadDestinations();
            this.built = true;
        }
    }

    private void loadDestinations() {
        Destination destination;
        HashSet<Destination> destinations = new HashSet<Destination>();
        destinations.addAll(this.getDestinations());
        for (String string : this.getDestinationJndiNames()) {
            destination = this.lookupDestination(string);
            destinations.add(destination);
        }
        for (AnnotatedParameter annotatedParameter : this.getAnnotatedParameters()) {
            destination = this.lookupDestination(annotatedParameter);
            destinations.add(destination);
        }
        this.logger.infof("Routing destinations: [%s]", destinations);
        this.setDestinations(destinations);
    }

    private Destination lookupDestination(String jndiName) {
        try {
            InitialContext c = new InitialContext();
            return (Destination)c.lookup(jndiName);
        }
        catch (NamingException e) {
            this.logger.warn((Object)("Unable to lookup " + jndiName), (Throwable)e);
            return null;
        }
    }

    private Destination lookupDestination(AnnotatedParameter<?> ap) {
        this.logger.debug((Object)("Looking up destination: " + ap));
        Set beans = this.bm.getBeans(Destination.class, new Annotation[0]);
        Bean bean = this.bm.resolve(beans);
        ImmutableInjectionPoint iip = new ImmutableInjectionPoint(ap, this.bm, bean, false, false);
        Object o = this.bm.getInjectableReference((InjectionPoint)iip, this.bm.createCreationalContext((Contextual)bean));
        return (Destination)o;
    }

    public Set<AnnotatedParameter<?>> getAnnotatedParameters() {
        return this.annotatedParameters;
    }

    public Route setType(Type type) {
        this.payloadType = type;
        return this;
    }

    public boolean validate() {
        if (this.payloadType == null) {
            this.logger.debug((Object)"No payload type found.");
            return false;
        }
        if (this.annotatedParameters.isEmpty() && this.destinationJndiNames.isEmpty() && this.destinations.isEmpty()) {
            this.logger.debug((Object)"No destinations configured.");
            return false;
        }
        return true;
    }

    public void setDestinations(Collection<Destination> destinations) {
        this.destinations = new HashSet<Destination>(destinations);
    }

    public Route id(String id) {
        this.id = id;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public boolean isEgressEnabled() {
        return this.egressEnabled;
    }

    public boolean isIngressEnabled() {
        return this.ingressEnabled;
    }

    public void disableEgress() {
        this.egressEnabled = false;
    }

    public void enableEgress() {
        this.egressEnabled = this.type == RouteType.BOTH || this.type == RouteType.EGRESS;
    }

    public void disableIngress() {
        this.ingressEnabled = false;
    }

    public void enableIngress() {
        this.ingressEnabled = this.type == RouteType.BOTH || this.type == RouteType.INGRESS;
    }
}

