/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.jms.bridge;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import org.jboss.seam.jms.Seam3JmsExtension;
import org.jboss.seam.jms.annotations.Routing;
import org.jboss.seam.jms.bridge.Route;
import org.jboss.seam.jms.bridge.RouteLocator;
import org.jboss.seam.jms.bridge.RouteType;

public class RouteLocatorImpl
implements RouteLocator {
    @Inject
    Seam3JmsExtension extension;
    private Map<String, Route> routeMap = new HashMap<String, Route>();

    @PostConstruct
    public void loadRoutes() {
        for (Route ingress : this.extension.getIngressRoutes()) {
            this.routeMap.put(ingress.getId(), ingress);
        }
        for (Route egress : this.extension.getEgressRoutes()) {
            this.routeMap.put(egress.getId(), egress);
        }
    }

    public Route findById(String id) {
        return this.routeMap.get(id);
    }

    @Produces
    @Routing(value=RouteType.INGRESS)
    public List<Route> produceIngressRoutes() {
        return this.extension.getIngressRoutes();
    }

    @Produces
    @Routing(value=RouteType.EGRESS)
    public List<Route> produceEgressRoutes() {
        return this.extension.getEgressRoutes();
    }
}

