/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.jms.impl.inject;

import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Inject;
import javax.jms.Destination;
import javax.jms.Queue;
import javax.jms.Topic;
import javax.naming.Context;
import javax.naming.NamingException;
import org.jboss.seam.jms.annotations.JmsDestination;
import org.jboss.solder.reflection.AnnotationInspector;

public class DestinationProducer {
    @Inject
    BeanManager beanManager;

    @Produces
    @JmsDestination
    public Topic getTopic(InjectionPoint ip, Context c) throws NamingException {
        JmsDestination d = (JmsDestination)AnnotationInspector.getAnnotation((Annotated)ip.getAnnotated(), JmsDestination.class, (BeanManager)this.beanManager);
        return this.resolveTopic(d.jndiName(), c);
    }

    @Produces
    @JmsDestination
    public Queue getQueue(InjectionPoint ip, Context c) throws NamingException {
        JmsDestination d = (JmsDestination)AnnotationInspector.getAnnotation((Annotated)ip.getAnnotated(), JmsDestination.class, (BeanManager)this.beanManager);
        return this.resolveQueue(d.jndiName(), c);
    }

    public Topic resolveTopic(String jndiName, Context c) throws NamingException {
        return (Topic)this.resolveDestination(jndiName, c);
    }

    public Queue resolveQueue(String jndiName, Context c) throws NamingException {
        return (Queue)this.resolveDestination(jndiName, c);
    }

    public Destination resolveDestination(String jndiName, Context c) throws NamingException {
        return (Destination)c.lookup(jndiName);
    }
}

