/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.jms.impl.inject;

import javax.enterprise.inject.Any;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Inject;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.Topic;
import javax.naming.Context;
import javax.naming.NamingException;
import org.jboss.seam.jms.annotations.JmsDefault;
import org.jboss.seam.jms.annotations.JmsDestination;
import org.jboss.seam.jms.impl.inject.DestinationProducer;
import org.jboss.solder.reflection.AnnotationInspector;

public class MessagePubSubProducer {
    @Inject
    @Any
    Instance<Topic> anyTopic;
    @Inject
    @Any
    Instance<Queue> anyQueue;
    @Inject
    BeanManager beanManager;
    @Inject
    DestinationProducer destinationProducer;
    @Inject
    Context c;

    @Produces
    @JmsDestination
    public MessageConsumer createMessageConsumer(InjectionPoint ip, @JmsDefault(value="session") Session s) throws JMSException, NamingException {
        JmsDestination d = (JmsDestination)AnnotationInspector.getAnnotation((Annotated)ip.getAnnotated(), JmsDestination.class, (BeanManager)this.beanManager);
        Destination dest = this.destinationProducer.resolveDestination(d.jndiName(), this.c);
        return s.createConsumer(dest);
    }

    public void disposesMessageConsumer(@Disposes @Any MessageConsumer mc) throws JMSException {
        mc.close();
    }

    @Produces
    @JmsDestination
    public MessageProducer createMessageProducer(InjectionPoint ip, @JmsDefault(value="session") Session s) throws JMSException, NamingException {
        JmsDestination d = (JmsDestination)AnnotationInspector.getAnnotation((Annotated)ip.getAnnotated(), JmsDestination.class, (BeanManager)this.beanManager);
        Destination dest = this.destinationProducer.resolveDestination(d.jndiName(), this.c);
        return s.createProducer(dest);
    }

    public void disposesMessageProducer(@Disposes @Any MessageProducer mp) throws JMSException {
        mp.close();
    }
}

