/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.jms.impl.inject;

import java.lang.annotation.Annotation;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.Session;
import org.jboss.seam.jms.annotations.JmsSession;

public class SessionProducer {
    @Produces
    @Dependent
    public Session getSession(Connection c, InjectionPoint ip) throws JMSException {
        JmsSession s = null;
        if (ip != null) {
            if (ip.getAnnotated().isAnnotationPresent(JmsSession.class)) {
                s = (JmsSession)ip.getAnnotated().getAnnotation(JmsSession.class);
            } else {
                for (Annotation a : ip.getAnnotated().getAnnotations()) {
                    if (!a.annotationType().isAnnotationPresent(JmsSession.class)) continue;
                    s = a.annotationType().getAnnotation(JmsSession.class);
                }
            }
            if (s != null) {
                return c.createSession(s.transacted(), s.acknowledgementMode());
            }
        }
        return c.createSession(false, 1);
    }

    public void closeSession(@Disposes @Any Session s) throws JMSException {
        s.close();
    }
}

