/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.jms.tools;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.QueueReceiver;
import javax.jms.TopicSubscriber;
import org.jboss.seam.jms.annotations.Closeable;
import org.jboss.solder.logging.Logger;

@ApplicationScoped
public class JMSResourceManager {
    private Logger logger = Logger.getLogger(JMSResourceManager.class);
    private List<Connection> closeableConnections = new ArrayList<Connection>();
    private List<TopicSubscriber> topicSubscribes = new ArrayList<TopicSubscriber>();
    private List<MessageConsumer> messageConsumers = new ArrayList<MessageConsumer>();
    private List<QueueReceiver> receives = new ArrayList<QueueReceiver>();

    public void addCloseableConnection(@Observes @Closeable Connection connection) {
        this.closeableConnections.add(connection);
    }

    public void addCloseableTS(@Observes @Closeable TopicSubscriber ts) {
        this.topicSubscribes.add(ts);
    }

    public void addCloseableQR(@Observes @Closeable QueueReceiver qr) {
        this.receives.add(qr);
    }

    public void addCloseableMC(@Observes @Closeable MessageConsumer mc) {
        this.messageConsumers.add(mc);
    }

    @PreDestroy
    public void shutdown() {
        for (MessageConsumer mc : this.messageConsumers) {
            try {
                mc.close();
            }
            catch (JMSException e) {
                this.logger.debug((Object)"Unable to close message consumer", (Throwable)e);
            }
        }
        for (TopicSubscriber ts : this.topicSubscribes) {
            try {
                ts.close();
            }
            catch (JMSException e) {
                this.logger.debug((Object)"Unable to close topic subscriber", (Throwable)e);
            }
        }
        for (QueueReceiver qr : this.receives) {
            try {
                qr.close();
            }
            catch (JMSException e) {
                this.logger.debug((Object)"Unable to close queue receiver", (Throwable)e);
            }
        }
        for (Connection conn : this.closeableConnections) {
            try {
                conn.close();
                conn.stop();
            }
            catch (JMSException e) {
                this.logger.debug((Object)"Unable to close connection", (Throwable)e);
            }
        }
    }
}

