/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.persistence.transactions.test;

import java.util.List;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import junit.framework.Assert;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.seam.persistence.test.util.HelloService;
import org.jboss.seam.persistence.test.util.Hotel;
import org.jboss.seam.persistence.transaction.DefaultTransaction;
import org.jboss.seam.persistence.transaction.SeamTransaction;
import org.junit.Test;
import org.junit.runner.RunWith;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RunWith(value=Arquillian.class)
public class UserTransactionTestBase {
    @Inject
    @DefaultTransaction
    SeamTransaction transaction;
    @PersistenceContext
    EntityManager em;

    public static Class<?>[] getTestClasses() {
        return new Class[]{UserTransactionTestBase.class, Hotel.class, HelloService.class};
    }

    @Test
    public void userTransactionTest() throws NotSupportedException, SystemException, SecurityException, IllegalStateException, RollbackException, HeuristicMixedException, HeuristicRollbackException {
        this.transaction.begin();
        this.em.joinTransaction();
        Hotel h = new Hotel("test", "Fake St", "Wollongong", "NSW", "2518", "Australia");
        this.em.persist((Object)h);
        this.em.flush();
        this.transaction.commit();
        this.em.clear();
        this.transaction.begin();
        this.em.joinTransaction();
        h = new Hotel("test2", "Fake St", "Wollongong", "NSW", "2518", "Australia");
        this.em.persist((Object)h);
        this.em.flush();
        this.transaction.rollback();
        this.em.clear();
        this.transaction.begin();
        this.em.joinTransaction();
        List hotels = this.em.createQuery("select h from Hotel h").getResultList();
        Assert.assertTrue((hotels.size() == 1 ? 1 : 0) != 0);
        this.transaction.rollback();
        this.em.clear();
    }

    @Test
    public void synchronizationsTest() throws NotSupportedException, SystemException, SecurityException, IllegalStateException, RollbackException, HeuristicMixedException, HeuristicRollbackException {
        TransactionAware sync = new TransactionAware();
        this.transaction.begin();
        this.transaction.registerSynchronization((Synchronization)sync);
        this.transaction.commit();
        Assert.assertEquals((int)1, (int)sync.getAfterCompletionCount());
        Assert.assertEquals((int)1, (int)sync.getBeforeCompletionCount());
        this.transaction.begin();
        this.transaction.registerSynchronization((Synchronization)sync);
        this.transaction.commit();
        Assert.assertEquals((int)2, (int)sync.getAfterCompletionCount());
        Assert.assertEquals((int)2, (int)sync.getBeforeCompletionCount());
    }

    private static class TransactionAware
    implements Synchronization {
        int beforeCompletionCount = 0;
        int afterCompletionCount = 0;

        private TransactionAware() {
        }

        public void afterCompletion(int status) {
            ++this.afterCompletionCount;
        }

        public void beforeCompletion() {
            ++this.beforeCompletionCount;
        }

        public int getAfterCompletionCount() {
            return this.afterCompletionCount;
        }

        public int getBeforeCompletionCount() {
            return this.beforeCompletionCount;
        }

        public void clear() {
            this.beforeCompletionCount = 0;
            this.afterCompletionCount = 0;
        }
    }
}

