/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.persistence.transactions.test;

import java.util.List;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TransactionRequiredException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import junit.framework.Assert;
import org.jboss.seam.persistence.test.util.DontRollBackException;
import org.jboss.seam.persistence.test.util.EntityManagerProvider;
import org.jboss.seam.persistence.test.util.HelloService;
import org.jboss.seam.persistence.test.util.Hotel;
import org.jboss.seam.persistence.transaction.DefaultTransaction;
import org.jboss.seam.persistence.transaction.SeamTransaction;
import org.jboss.seam.persistence.transactions.test.StereotypeTransactionManagedBean;
import org.jboss.seam.persistence.transactions.test.TransactionalStereotype;
import org.junit.Test;

public class TransactionInterceptorStereotypeTestBase {
    @Inject
    StereotypeTransactionManagedBean bean;
    @Inject
    @DefaultTransaction
    SeamTransaction transaction;
    @PersistenceContext
    EntityManager em;

    public static Class<?>[] getTestClasses() {
        return new Class[]{TransactionInterceptorStereotypeTestBase.class, TransactionalStereotype.class, StereotypeTransactionManagedBean.class, HelloService.class, Hotel.class, EntityManagerProvider.class, DontRollBackException.class};
    }

    @Test
    public void testTransactionInterceptor() throws NotSupportedException, SystemException, SecurityException, IllegalStateException, RollbackException, HeuristicMixedException, HeuristicRollbackException {
        this.bean.addHotel();
        this.assertHotels(1);
        try {
            this.bean.failToAddHotel();
        }
        catch (Exception e) {
            // empty catch block
        }
        this.assertHotels(1);
        try {
            this.bean.addHotelWithApplicationException();
        }
        catch (DontRollBackException dontRollBackException) {
            // empty catch block
        }
        this.assertHotels(2);
    }

    @Test(expected=TransactionRequiredException.class)
    public void testTransactionInterceptorMethodOverrides() {
        this.bean.tryAndAddHotelWithNoTransaction();
    }

    public void assertHotels(int count) throws NotSupportedException, SystemException {
        this.transaction.begin();
        this.em.joinTransaction();
        List hotels = this.em.createQuery("select h from Hotel h").getResultList();
        Assert.assertTrue((String)("Wrong number of hotels: " + hotels.size()), (hotels.size() == count ? 1 : 0) != 0);
        this.transaction.rollback();
    }
}

