/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.persistence.transactions.test;

import javax.inject.Inject;
import javax.persistence.EntityManager;
import org.jboss.seam.persistence.test.util.DontRollBackException;
import org.jboss.seam.persistence.test.util.Hotel;
import org.jboss.seam.persistence.transactions.test.TransactionalStereotype;
import org.jboss.seam.transaction.TransactionPropagation;
import org.jboss.seam.transaction.Transactional;

@TransactionalStereotype
public class StereotypeTransactionManagedBean {
    @Inject
    EntityManager entityManager;

    public void addHotel() {
        this.entityManager.joinTransaction();
        Hotel h = new Hotel("test", "Fake St", "Wollongong", "NSW", "2518", "Australia");
        this.entityManager.persist((Object)h);
        this.entityManager.flush();
    }

    public void failToAddHotel() {
        this.entityManager.joinTransaction();
        Hotel h = new Hotel("test2", "Fake St", "Wollongong", "NSW", "2518", "Australia");
        this.entityManager.persist((Object)h);
        this.entityManager.flush();
        throw new RuntimeException("Roll back transaction");
    }

    public void addHotelWithApplicationException() throws DontRollBackException {
        this.entityManager.joinTransaction();
        Hotel h = new Hotel("test3", "Fake St", "Wollongong", "NSW", "2518", "Australia");
        this.entityManager.persist((Object)h);
        this.entityManager.flush();
        throw new DontRollBackException();
    }

    @Transactional(value=TransactionPropagation.NEVER)
    public void tryAndAddHotelWithNoTransaction() {
        this.entityManager.joinTransaction();
        Hotel h = new Hotel("test3", "Fake St", "Wollongong", "NSW", "2518", "Australia");
        this.entityManager.persist((Object)h);
        this.entityManager.flush();
    }
}

