/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.persistence;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Set;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.transaction.Synchronization;
import org.hibernate.FlushMode;
import org.hibernate.Session;
import org.hibernate.TransientObjectException;
import org.hibernate.proxy.HibernateProxy;
import org.jboss.seam.persistence.DefaultPersistenceProvider;
import org.jboss.seam.persistence.FlushModeType;
import org.jboss.seam.solder.core.Veto;
import org.jboss.seam.solder.reflection.Reflections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Veto
public class HibernatePersistenceProvider
extends DefaultPersistenceProvider {
    private static Logger log;
    private static Class<?> FULL_TEXT_SESSION;
    private static Method FULL_TEXT_SESSION_CONSTRUCTOR;
    private static Method FULL_TEXT_ENTITYMANAGER_CONSTRUCTOR;
    private static Class<?> FULL_TEXT_ENTITYMANAGER;

    @Inject
    public void init() {
        this.featureSet.add(DefaultPersistenceProvider.Feature.WILDCARD_AS_COUNT_QUERY_SUBJECT);
    }

    @Override
    public boolean isCorrectProvider(EntityManager em) {
        return em.getDelegate() instanceof Session;
    }

    @Override
    public void setFlushModeManual(EntityManager entityManager) {
        try {
            this.getSession(entityManager).setFlushMode(FlushMode.MANUAL);
        }
        catch (NotHibernateException nhe) {
            super.setFlushModeManual(entityManager);
        }
    }

    @Override
    public FlushModeType getRenderFlushMode() {
        return FlushModeType.MANUAL;
    }

    @Override
    public boolean isDirty(EntityManager entityManager) {
        try {
            return this.getSession(entityManager).isDirty();
        }
        catch (NotHibernateException nhe) {
            return super.isDirty(entityManager);
        }
    }

    @Override
    public Object getId(Object bean, EntityManager entityManager) {
        try {
            return this.getSession(entityManager).getIdentifier(bean);
        }
        catch (NotHibernateException nhe) {
            return super.getId(bean, entityManager);
        }
        catch (TransientObjectException e) {
            if (bean instanceof HibernateProxy) {
                return super.getId(((HibernateProxy)bean).getHibernateLazyInitializer().getImplementation(), entityManager);
            }
            return super.getId(bean, entityManager);
        }
    }

    @Override
    public boolean registerSynchronization(Synchronization sync, EntityManager entityManager) {
        try {
            this.getSession(entityManager).getTransaction().registerSynchronization(sync);
            return true;
        }
        catch (NotHibernateException nhe) {
            return super.registerSynchronization(sync, entityManager);
        }
    }

    @Override
    public String getName(Object bean, EntityManager entityManager) throws IllegalArgumentException {
        try {
            return this.getSession(entityManager).getEntityName(bean);
        }
        catch (NotHibernateException nhe) {
            return super.getName(bean, entityManager);
        }
        catch (Exception e) {
            return super.getName(bean, entityManager);
        }
    }

    private Session getSession(EntityManager entityManager) {
        Object delegate = entityManager.getDelegate();
        if (delegate instanceof Session) {
            return (Session)delegate;
        }
        throw new NotHibernateException();
    }

    static Session proxySession(Session session) {
        if (FULL_TEXT_SESSION_CONSTRUCTOR == null || FULL_TEXT_SESSION == null) {
            return session;
        }
        if (FULL_TEXT_SESSION.isAssignableFrom(session.getClass())) {
            return session;
        }
        try {
            return (Session)FULL_TEXT_SESSION_CONSTRUCTOR.invoke(null, session);
        }
        catch (Exception e) {
            log.warn("Unable to wrap into a FullTextSessionProxy, regular SessionProxy returned", (Throwable)e);
            return session;
        }
    }

    @Override
    public Object proxyDelegate(Object delegate) {
        try {
            return HibernatePersistenceProvider.proxySession((Session)delegate);
        }
        catch (NotHibernateException nhe) {
            return super.proxyDelegate(delegate);
        }
        catch (Exception e) {
            throw new RuntimeException("could not proxy delegate", e);
        }
    }

    @Override
    public EntityManager proxyEntityManager(EntityManager entityManager) {
        if (FULL_TEXT_ENTITYMANAGER_CONSTRUCTOR == null) {
            return super.proxyEntityManager(entityManager);
        }
        try {
            return (EntityManager)FULL_TEXT_ENTITYMANAGER_CONSTRUCTOR.invoke(null, super.proxyEntityManager(entityManager));
        }
        catch (Exception e) {
            return super.proxyEntityManager(entityManager);
        }
    }

    @Override
    public Set<Class<?>> getAdditionalEntityManagerInterfaces() {
        if (FULL_TEXT_ENTITYMANAGER == null) {
            return Collections.emptySet();
        }
        return Collections.singleton(FULL_TEXT_ENTITYMANAGER);
    }

    public Set<Class<?>> getAdditionalSessionInterfaces() {
        if (FULL_TEXT_SESSION == null) {
            return Collections.emptySet();
        }
        return Collections.singleton(FULL_TEXT_SESSION);
    }

    static {
        block8: {
            log = LoggerFactory.getLogger(HibernatePersistenceProvider.class);
            try {
                boolean hibernateSearchPresent = false;
                try {
                    Reflections.classForName((String)"org.hibernate.search.Version", (ClassLoader[])new ClassLoader[0]);
                    hibernateSearchPresent = true;
                }
                catch (Exception e) {
                    log.debug("no Hibernate Search", (Throwable)e);
                }
                if (!hibernateSearchPresent) break block8;
                Class searchClass = Reflections.classForName((String)"org.hibernate.search.Search", (ClassLoader[])new ClassLoader[0]);
                try {
                    FULL_TEXT_SESSION_CONSTRUCTOR = searchClass.getDeclaredMethod("getFullTextSession", Session.class);
                }
                catch (NoSuchMethodException noSuchMethod) {
                    log.debug("org.hibernate.search.Search.getFullTextSession(Session) not found, trying deprecated method name createFullTextSession");
                    FULL_TEXT_SESSION_CONSTRUCTOR = searchClass.getDeclaredMethod("createFullTextSession", Session.class);
                }
                FULL_TEXT_SESSION = Reflections.classForName((String)"org.hibernate.search.FullTextSession", (ClassLoader[])new ClassLoader[0]);
                Class jpaSearchClass = Reflections.classForName((String)"org.hibernate.search.jpa.Search", (ClassLoader[])new ClassLoader[0]);
                try {
                    FULL_TEXT_ENTITYMANAGER_CONSTRUCTOR = jpaSearchClass.getDeclaredMethod("getFullTextEntityManager", EntityManager.class);
                }
                catch (NoSuchMethodException noSuchMethod) {
                    log.debug("org.hibernate.search.jpa.getFullTextSession(EntityManager) not found, trying deprecated method name createFullTextEntityManager");
                    FULL_TEXT_ENTITYMANAGER_CONSTRUCTOR = jpaSearchClass.getDeclaredMethod("createFullTextEntityManager", EntityManager.class);
                }
                FULL_TEXT_ENTITYMANAGER = Reflections.classForName((String)"org.hibernate.search.jpa.FullTextEntityManager", (ClassLoader[])new ClassLoader[0]);
                log.info("Hibernate Search is available");
            }
            catch (Exception e) {
                log.debug("no Hibernate Search", (Throwable)e);
            }
        }
    }

    static class NotHibernateException
    extends IllegalArgumentException {
        NotHibernateException() {
        }
    }
}

