/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.persistence;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.jboss.seam.persistence.FlushModeType;
import org.jboss.seam.persistence.ManagedPersistenceContext;
import org.jboss.seam.persistence.ManagedPersistenceContextProxyHandler;
import org.jboss.seam.persistence.PersistenceContexts;
import org.jboss.seam.persistence.SeamManagedPersistenceContextCreated;
import org.jboss.seam.persistence.SeamPersistenceProvider;
import org.jboss.seam.solder.bean.ContextualLifecycle;
import org.jboss.seam.solder.literal.DefaultLiteral;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedPersistenceContextBeanLifecycle
implements ContextualLifecycle<EntityManager> {
    private static final Logger log = LoggerFactory.getLogger(ManagedPersistenceContextBeanLifecycle.class);
    private final Class<?> proxyClass;
    private final Constructor<?> proxyConstructor;
    private volatile SeamPersistenceProvider persistenceProvider;
    private volatile PersistenceContexts persistenceContexts;
    protected final Annotation[] qualifiers;
    protected final BeanManager manager;
    private EntityManagerFactory emf;
    private final List<SeamPersistenceProvider> persistenceProviders;

    public ManagedPersistenceContextBeanLifecycle(Set<Annotation> qualifiers, ClassLoader loader, BeanManager manager, Set<Class<?>> additionalinterfaces, List<SeamPersistenceProvider> persistenceProviders) {
        this.manager = manager;
        this.persistenceProviders = new ArrayList<SeamPersistenceProvider>(persistenceProviders);
        Class[] interfaces = new Class[additionalinterfaces.size() + 3];
        int count = 0;
        for (Class<?> i : additionalinterfaces) {
            interfaces[count++] = i;
        }
        interfaces[count++] = EntityManager.class;
        interfaces[count++] = Serializable.class;
        interfaces[count++] = ManagedPersistenceContext.class;
        this.proxyClass = Proxy.getProxyClass(loader, interfaces);
        try {
            this.proxyConstructor = this.proxyClass.getConstructor(InvocationHandler.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.qualifiers = new Annotation[qualifiers.size()];
        int i = 0;
        for (Annotation a : qualifiers) {
            this.qualifiers[i++] = a;
        }
    }

    public EntityManager create(Bean<EntityManager> bean, CreationalContext<EntityManager> arg0) {
        try {
            EntityManagerFactory emf = this.getEntityManagerFactory();
            EntityManager entityManager = emf.createEntityManager();
            entityManager = this.getPersistenceProvider(entityManager).proxyEntityManager(entityManager);
            PersistenceContexts persistenceContexts = null;
            try {
                persistenceContexts = this.getPersistenceContexts();
            }
            catch (ContextNotActiveException e) {
                // empty catch block
            }
            ManagedPersistenceContextProxyHandler handler = new ManagedPersistenceContextProxyHandler(entityManager, this.manager, bean.getQualifiers(), persistenceContexts, this.getPersistenceProvider(entityManager));
            EntityManager proxy = (EntityManager)this.proxyConstructor.newInstance(handler);
            arg0.push((Object)proxy);
            this.getPersistenceProvider(entityManager).setFlushMode(proxy, this.getFlushMode());
            this.manager.fireEvent((Object)new SeamManagedPersistenceContextCreated(entityManager), this.qualifiers);
            return proxy;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private FlushModeType getFlushMode() {
        try {
            return this.getPersistenceContexts().getFlushMode();
        }
        catch (ContextNotActiveException e) {
            return FlushModeType.AUTO;
        }
    }

    public void destroy(Bean<EntityManager> bean, EntityManager em, CreationalContext<EntityManager> arg1) {
        ((ManagedPersistenceContext)em).closeAfterTransaction();
        arg1.release();
        try {
            this.getPersistenceContexts().untouch((ManagedPersistenceContext)em);
        }
        catch (ContextNotActiveException e) {
            log.debug("Could not untouch PersistenceContext as conversation scope not active");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PersistenceContexts getPersistenceContexts() {
        if (this.persistenceContexts == null) {
            ManagedPersistenceContextBeanLifecycle managedPersistenceContextBeanLifecycle = this;
            synchronized (managedPersistenceContextBeanLifecycle) {
                if (this.persistenceContexts == null) {
                    Bean bean = this.manager.resolve(this.manager.getBeans(PersistenceContexts.class, new Annotation[]{DefaultLiteral.INSTANCE}));
                    if (bean == null) {
                        throw new RuntimeException("Could not find PersistenceContexts bean");
                    }
                    CreationalContext ctx = this.manager.createCreationalContext((Contextual)bean);
                    this.persistenceContexts = (PersistenceContexts)this.manager.getReference(bean, PersistenceContexts.class, ctx);
                }
            }
        }
        return this.persistenceContexts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SeamPersistenceProvider getPersistenceProvider(EntityManager em) {
        if (this.persistenceProvider == null) {
            ManagedPersistenceContextBeanLifecycle managedPersistenceContextBeanLifecycle = this;
            synchronized (managedPersistenceContextBeanLifecycle) {
                if (this.persistenceProvider == null) {
                    for (SeamPersistenceProvider i : this.persistenceProviders) {
                        if (!i.isCorrectProvider(em)) continue;
                        this.persistenceProvider = i;
                        break;
                    }
                }
            }
        }
        return this.persistenceProvider;
    }

    protected EntityManagerFactory getEntityManagerFactory() {
        if (this.emf == null) {
            Bean bean = this.manager.resolve(this.manager.getBeans(EntityManagerFactory.class, this.qualifiers));
            if (bean == null) {
                throw new RuntimeException("Could not find EntityManagerFactory bean with qualifiers" + Arrays.toString(this.qualifiers));
            }
            CreationalContext ctx = this.manager.createCreationalContext((Contextual)bean);
            this.emf = (EntityManagerFactory)this.manager.getReference(bean, EntityManagerFactory.class, ctx);
        }
        return this.emf;
    }
}

