/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.transaction;

import javax.enterprise.context.RequestScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import org.jboss.seam.persistence.DefaultPersistenceProvider;
import org.jboss.seam.solder.core.Veto;
import org.jboss.seam.transaction.AbstractUserTransaction;
import org.jboss.seam.transaction.DefaultTransaction;
import org.jboss.seam.transaction.Synchronizations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequestScoped
@DefaultTransaction
@Veto
public class EntityTransaction
extends AbstractUserTransaction {
    private static final Logger log = LoggerFactory.getLogger(EntityTransaction.class);
    @Inject
    private EntityManager entityManager;
    @Inject
    private Instance<DefaultPersistenceProvider> persistenceProvider;

    @Inject
    public void init(Synchronizations sync) {
        this.setSynchronizations(sync);
    }

    private javax.persistence.EntityTransaction getDelegate() {
        return this.entityManager.getTransaction();
    }

    public void begin() throws NotSupportedException, SystemException {
        log.debug("beginning JPA resource-local transaction");
        this.getDelegate().begin();
        this.getSynchronizations().afterTransactionBegin();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        log.debug("committing JPA resource-local transaction");
        javax.persistence.EntityTransaction delegate = this.getDelegate();
        boolean success = false;
        try {
            if (delegate.getRollbackOnly()) {
                delegate.rollback();
                throw new RollbackException();
            }
            this.getSynchronizations().beforeTransactionCommit();
            delegate.commit();
            success = true;
        }
        finally {
            this.getSynchronizations().afterTransactionCompletion(success);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        log.debug("rolling back JPA resource-local transaction");
        javax.persistence.EntityTransaction delegate = this.getDelegate();
        try {
            delegate.rollback();
        }
        finally {
            this.getSynchronizations().afterTransactionCompletion(false);
        }
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        log.debug("marking JPA resource-local transaction for rollback");
        this.getDelegate().setRollbackOnly();
    }

    public int getStatus() throws SystemException {
        if (this.getDelegate().isActive()) {
            if (this.getDelegate().getRollbackOnly()) {
                return 1;
            }
            return 0;
        }
        return 6;
    }

    public void setTransactionTimeout(int timeout) throws SystemException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void registerSynchronization(Synchronization sync) {
        if (log.isDebugEnabled()) {
            log.debug("registering synchronization: " + sync);
        }
        if (!((DefaultPersistenceProvider)this.persistenceProvider.get()).registerSynchronization(sync, this.entityManager)) {
            this.getSynchronizations().registerSynchronization(sync);
        }
    }

    @Override
    public boolean isConversationContextRequired() {
        return true;
    }

    @Override
    public void enlist(EntityManager entityManager) {
    }
}

