/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.transaction;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.transaction.Synchronization;
import org.jboss.seam.solder.core.Veto;
import org.jboss.seam.transaction.SynchronizationRegistry;
import org.jboss.seam.transaction.Synchronizations;
import org.jboss.seam.transaction.ThreadLocalStack;

@ApplicationScoped
@Veto
public class SeSynchronizations
implements Synchronizations {
    protected ThreadLocalStack<SynchronizationRegistry> synchronizations = new ThreadLocalStack();
    @Inject
    private BeanManager beanManager;

    @Override
    public void afterTransactionBegin() {
        this.synchronizations.push(new SynchronizationRegistry(this.beanManager));
    }

    @Override
    public void afterTransactionCompletion(boolean success) {
        if (!this.synchronizations.isEmpty()) {
            this.synchronizations.pop().afterTransactionCompletion(success);
        }
    }

    @Override
    public void beforeTransactionCommit() {
        if (!this.synchronizations.isEmpty()) {
            this.synchronizations.peek().beforeTransactionCompletion();
        }
    }

    @Override
    public void registerSynchronization(Synchronization sync) {
        if (this.synchronizations.isEmpty()) {
            throw new IllegalStateException("Transaction begin not detected, try installing transaction:ejb-transaction in components.xml");
        }
        this.synchronizations.peek().registerSynchronization(sync);
    }

    @Override
    public boolean isAwareOfContainerTransactions() {
        return false;
    }
}

