/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.transaction;

import java.util.NoSuchElementException;
import java.util.concurrent.LinkedBlockingDeque;

class ThreadLocalStack<T> {
    private final ThreadLocal<LinkedBlockingDeque<T>> stack = new ThreadLocal();

    ThreadLocalStack() {
    }

    public void push(T t) {
        if (this.stack.get() == null) {
            this.stack.set(new LinkedBlockingDeque());
        }
        this.stack.get().push(t);
    }

    public T pop() {
        LinkedBlockingDeque<T> queue = this.stack.get();
        if (queue == null) {
            throw new NoSuchElementException();
        }
        T t = queue.pop();
        if (queue.isEmpty()) {
            this.stack.remove();
        }
        return t;
    }

    public T peek() {
        LinkedBlockingDeque<T> queue = this.stack.get();
        if (queue == null) {
            return null;
        }
        return queue.peek();
    }

    public boolean isEmpty() {
        LinkedBlockingDeque<T> queue = this.stack.get();
        if (queue == null) {
            return true;
        }
        return queue.isEmpty();
    }
}

