/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.transaction;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.jboss.seam.persistence.util.EjbApi;
import org.jboss.seam.transaction.DefaultTransaction;
import org.jboss.seam.transaction.SeamTransaction;
import org.jboss.seam.transaction.TransactionExtension;
import org.jboss.seam.transaction.TransactionPropagation;
import org.jboss.seam.transaction.Transactional;
import org.jboss.seam.transaction.TransactionalInterceptorBinding;
import org.jboss.seam.transaction.Work;

@TransactionalInterceptorBinding
@Interceptor
public class TransactionInterceptor
implements Serializable {
    private static final long serialVersionUID = -4364203056333738988L;
    private transient Map<AnnotatedElement, TransactionMetadata> transactionMetadata = new HashMap<AnnotatedElement, TransactionMetadata>();
    @Inject
    @DefaultTransaction
    private Instance<SeamTransaction> transaction;
    @Inject
    private TransactionExtension transactionExtension;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TransactionMetadata lookupTransactionMetadata(Method element) {
        TransactionMetadata metadata;
        if (this.transactionMetadata == null) {
            this.transactionMetadata = new HashMap<AnnotatedElement, TransactionMetadata>();
        }
        if ((metadata = this.transactionMetadata.get(element)) == null) {
            TransactionInterceptor transactionInterceptor = this;
            synchronized (transactionInterceptor) {
                metadata = element.isAnnotationPresent(Transactional.class) ? new TransactionMetadata(element.getAnnotation(Transactional.class)) : (element.isAnnotationPresent(EjbApi.TRANSACTION_ATTRIBUTE) ? new TransactionMetadata(element.getAnnotation(EjbApi.TRANSACTION_ATTRIBUTE)) : new TransactionMetadata(null));
                this.transactionMetadata.put(element, metadata);
            }
        }
        return metadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TransactionMetadata lookupTransactionMetadata(Class<?> element) {
        TransactionMetadata metadata;
        if (this.transactionMetadata == null) {
            this.transactionMetadata = new HashMap<AnnotatedElement, TransactionMetadata>();
        }
        if ((metadata = this.transactionMetadata.get(element)) == null) {
            TransactionInterceptor transactionInterceptor = this;
            synchronized (transactionInterceptor) {
                metadata = new TransactionMetadata(this.transactionExtension.getClassLevelTransactionAnnotation(element));
                this.transactionMetadata.put(element, metadata);
            }
        }
        return metadata;
    }

    @AroundInvoke
    public Object aroundInvoke(final InvocationContext invocation) throws Exception {
        return new Work(){

            protected Object work() throws Exception {
                return invocation.proceed();
            }

            @Override
            protected boolean isNewTransactionRequired(boolean transactionActive) {
                return this.isNewTransactionRequired(invocation.getMethod(), invocation.getMethod().getDeclaringClass(), transactionActive);
            }

            private boolean isNewTransactionRequired(Method method, Class<?> beanClass, boolean transactionActive) {
                TransactionMetadata metadata = TransactionInterceptor.this.lookupTransactionMetadata(method);
                if (metadata.isAnnotationPresent()) {
                    return metadata.isNewTransactionRequired(transactionActive);
                }
                metadata = TransactionInterceptor.this.lookupTransactionMetadata(beanClass);
                return metadata.isNewTransactionRequired(transactionActive);
            }
        }.workInTransaction((SeamTransaction)this.transaction.get());
    }

    private class TransactionMetadata {
        private final boolean annotationPresent;
        private final TransactionPropagation propType;

        public TransactionMetadata(Annotation annotation) {
            if (annotation == null) {
                this.annotationPresent = false;
                this.propType = null;
            } else if (annotation.annotationType() == Transactional.class) {
                this.annotationPresent = true;
                this.propType = ((Transactional)annotation).value();
            } else if (annotation.annotationType() == EjbApi.TRANSACTION_ATTRIBUTE) {
                this.annotationPresent = true;
                try {
                    Object value = annotation.getClass().getMethod("value", new Class[0]).invoke((Object)annotation, new Object[0]);
                    if (value == EjbApi.REQUIRED) {
                        this.propType = TransactionPropagation.REQUIRED;
                    }
                    if (value == EjbApi.MANDATORY) {
                        this.propType = TransactionPropagation.MANDATORY;
                    }
                    if (value == EjbApi.NEVER) {
                        this.propType = TransactionPropagation.NEVER;
                    }
                    if (value == EjbApi.SUPPORTS) {
                        this.propType = TransactionPropagation.SUPPORTS;
                    }
                    if (value == EjbApi.NOT_SUPPORTED) {
                        throw new RuntimeException("TransactionAttributeType.NOT_SUPPORTED is not allowed on managed beans that are not EJB's.");
                    }
                    if (value == EjbApi.REQUIRES_NEW) {
                        throw new RuntimeException("TransactionAttributeType.REQUIRES_NEW is not allowed on managed beans that are not EJB's.");
                    }
                    throw new RuntimeException("Unkown TransactionAttributeType: " + value);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            } else {
                this.annotationPresent = false;
                this.propType = null;
            }
        }

        public boolean isAnnotationPresent() {
            return this.annotationPresent;
        }

        public boolean isNewTransactionRequired(boolean transactionActive) {
            return this.propType != null && this.propType.isNewTransactionRequired(transactionActive);
        }
    }
}

