/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.transaction;

import javax.ejb.Remove;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.seam.solder.bean.defaultbean.DefaultBean;
import org.jboss.seam.transaction.SynchronizationRegistry;
import org.jboss.seam.transaction.Synchronizations;
import org.jboss.seam.transaction.ThreadLocalStack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
@DefaultBean(value=Synchronizations.class)
public class TransactionManagerSynchronizations
implements Synchronization,
Synchronizations {
    private static final Logger log = LoggerFactory.getLogger(TransactionManagerSynchronizations.class);
    private final String[] JNDI_LOCATIONS = new String[]{"java:/TransactionManager", "java:appserver/TransactionManager", "java:comp/TransactionManager", "java:pm/TransactionManager"};
    private static volatile String foundJndiLocation;
    @Inject
    private BeanManager beanManager;
    protected ThreadLocalStack<SynchronizationRegistry> synchronizations = new ThreadLocalStack();
    protected ThreadLocalStack<Transaction> transactions = new ThreadLocalStack();

    public void beforeCompletion() {
        log.debug("beforeCompletion");
        SynchronizationRegistry sync = this.synchronizations.peek();
        sync.beforeTransactionCompletion();
    }

    public void afterCompletion(int status) {
        this.transactions.pop();
        log.debug("afterCompletion");
        this.synchronizations.pop().afterTransactionCompletion((3 & status) == 0);
    }

    @Override
    public boolean isAwareOfContainerTransactions() {
        return true;
    }

    @Override
    public void registerSynchronization(Synchronization sync) {
        try {
            TransactionManager manager = this.getTransactionManager();
            Transaction transaction = manager.getTransaction();
            if (this.transactions.isEmpty() || this.transactions.peek().equals(transaction)) {
                this.transactions.push(transaction);
                this.synchronizations.push(new SynchronizationRegistry(this.beanManager));
                transaction.registerSynchronization((Synchronization)this);
            }
            this.synchronizations.peek().registerSynchronization(sync);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Remove
    public void destroy() {
    }

    public TransactionManager getTransactionManager() {
        if (foundJndiLocation != null) {
            try {
                return (TransactionManager)new InitialContext().lookup(foundJndiLocation);
            }
            catch (NamingException e) {
                log.trace("Could not find transaction manager under" + foundJndiLocation);
            }
        }
        for (String location : this.JNDI_LOCATIONS) {
            try {
                TransactionManager manager = (TransactionManager)new InitialContext().lookup(location);
                foundJndiLocation = location;
                return manager;
            }
            catch (NamingException e) {
                log.trace("Could not find transaction manager under" + location);
            }
        }
        throw new RuntimeException("Could not find TransactionManager in JNDI");
    }

    @Override
    public void afterTransactionBegin() {
    }

    @Override
    public void afterTransactionCompletion(boolean success) {
    }

    @Override
    public void beforeTransactionCommit() {
    }
}

