/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.persistence;

import java.io.Serializable;
import java.lang.reflect.Method;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.BeanManager;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.jboss.logging.Logger;
import org.jboss.seam.persistence.QueryParser;
import org.jboss.seam.persistence.util.InstanceResolver;
import org.jboss.seam.solder.el.Expressions;

public class PersistenceContextProxyHandler
implements Serializable {
    private static final long serialVersionUID = -6539267789786229774L;
    private final EntityManager delegate;
    private final Instance<Expressions> expressionsInstance;
    static final Logger log = Logger.getLogger(PersistenceContextProxyHandler.class);

    public PersistenceContextProxyHandler(EntityManager delegate, BeanManager beanManager) {
        this.delegate = delegate;
        this.expressionsInstance = InstanceResolver.getInstance(Expressions.class, beanManager);
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if ("createQuery".equals(method.getName()) && method.getParameterTypes().length > 0 && method.getParameterTypes()[0].equals(String.class)) {
            return this.handleCreateQueryWithString(method, args);
        }
        return method.invoke((Object)this.delegate, args);
    }

    protected Object handleCreateQueryWithString(Method method, Object[] args) throws Throwable {
        if (args[0] == null) {
            return method.invoke((Object)this.delegate, args);
        }
        String ejbql = (String)args[0];
        if (ejbql.indexOf(35) > 0) {
            Expressions expressions = (Expressions)this.expressionsInstance.get();
            QueryParser qp = new QueryParser(expressions, ejbql);
            Object[] newArgs = (Object[])args.clone();
            newArgs[0] = qp.getEjbql();
            Query query = (Query)method.invoke((Object)this.delegate, newArgs);
            for (int i = 0; i < qp.getParameterValues().size(); ++i) {
                query.setParameter(QueryParser.getParameterName(i), qp.getParameterValues().get(i));
            }
            return query;
        }
        return method.invoke((Object)this.delegate, args);
    }
}

