/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.transaction;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import org.jboss.logging.Logger;
import org.jboss.seam.persistence.util.EjbApi;
import org.jboss.seam.solder.reflection.annotated.AnnotatedTypeBuilder;
import org.jboss.seam.transaction.TransactionInterceptorBindingLiteral;
import org.jboss.seam.transaction.Transactional;

public class TransactionExtension
implements Extension {
    private static final Logger log = Logger.getLogger(TransactionExtension.class);
    private final Set<Throwable> exceptions = new HashSet<Throwable>();
    private final Map<Class<?>, Annotation> classLevelAnnotations = new HashMap();

    public <X> void processAnnotatedType(@Observes ProcessAnnotatedType<X> event, BeanManager beanManager) {
        AnnotatedTypeBuilder builder = null;
        AnnotatedType type = event.getAnnotatedType();
        boolean addedToClass = false;
        if (type.isAnnotationPresent(Transactional.class)) {
            builder = new AnnotatedTypeBuilder().readFromType(type);
            builder.addToClass((Annotation)((Object)TransactionInterceptorBindingLiteral.INSTANCE));
            addedToClass = true;
            this.classLevelAnnotations.put(type.getJavaClass(), type.getAnnotation(Transactional.class));
        } else if (type.isAnnotationPresent(EjbApi.TRANSACTION_ATTRIBUTE) && !EjbApi.isEjb(event.getAnnotatedType())) {
            this.checkTransactionAttributeIsValue(type, (Annotated)type);
            builder = new AnnotatedTypeBuilder().readFromType(type);
            builder.addToClass((Annotation)((Object)TransactionInterceptorBindingLiteral.INSTANCE));
            addedToClass = true;
            this.classLevelAnnotations.put(type.getJavaClass(), type.getAnnotation(EjbApi.TRANSACTION_ATTRIBUTE));
        }
        if (!addedToClass) {
            for (Annotation annotation : type.getAnnotations()) {
                if (!beanManager.isStereotype(annotation.annotationType())) continue;
                for (Annotation stereotypeAnnotation : beanManager.getStereotypeDefinition(annotation.annotationType())) {
                    if (stereotypeAnnotation.annotationType().equals(Transactional.class)) {
                        builder = new AnnotatedTypeBuilder().readFromType(type);
                        builder.addToClass((Annotation)((Object)TransactionInterceptorBindingLiteral.INSTANCE));
                        addedToClass = true;
                        this.classLevelAnnotations.put(type.getJavaClass(), stereotypeAnnotation);
                        continue;
                    }
                    if (!stereotypeAnnotation.annotationType().equals(EjbApi.TRANSACTION_ATTRIBUTE) || EjbApi.isEjb(event.getAnnotatedType())) continue;
                    this.checkTransactionAttributeIsValue(type, (Annotated)type);
                    builder = new AnnotatedTypeBuilder().readFromType(type);
                    builder.addToClass((Annotation)((Object)TransactionInterceptorBindingLiteral.INSTANCE));
                    addedToClass = true;
                    this.classLevelAnnotations.put(type.getJavaClass(), stereotypeAnnotation);
                }
            }
        }
        if (!addedToClass) {
            for (AnnotatedMethod m : type.getMethods()) {
                if (m.isAnnotationPresent(Transactional.class)) {
                    if (builder == null) {
                        builder = new AnnotatedTypeBuilder().readFromType(type);
                    }
                    builder.addToMethod(m, (Annotation)((Object)TransactionInterceptorBindingLiteral.INSTANCE));
                    continue;
                }
                if (!m.isAnnotationPresent(EjbApi.TRANSACTION_ATTRIBUTE) || EjbApi.isEjb(event.getAnnotatedType())) continue;
                this.checkTransactionAttributeIsValue(type, (Annotated)m);
                if (builder == null) {
                    builder = new AnnotatedTypeBuilder().readFromType(type);
                }
                builder.addToMethod(m, (Annotation)((Object)TransactionInterceptorBindingLiteral.INSTANCE));
            }
        }
        if (builder != null) {
            event.setAnnotatedType(builder.create());
        }
    }

    public Annotation getClassLevelTransactionAnnotation(Class<?> clazz) {
        return this.classLevelAnnotations.get(clazz);
    }

    private void afterBeanDiscover(@Observes AfterBeanDiscovery event) {
        for (Throwable throwable : this.exceptions) {
            event.addDefinitionError(throwable);
        }
    }

    private void checkTransactionAttributeIsValue(AnnotatedType type, Annotated element) {
        Annotation attribute = element.getAnnotation(EjbApi.TRANSACTION_ATTRIBUTE);
        if (attribute == EjbApi.REQUIRES_NEW) {
            this.exceptions.add(new RuntimeException("TransactionAttributeType.REQUIRED_NEW is not supported on Managed Beans that are not EJB's. Annotation was found on type " + type));
        }
        if (attribute == EjbApi.NOT_SUPPORTED) {
            this.exceptions.add(new RuntimeException("TransactionAttributeType.NOT_SUPPORTED is not supported on Managed Beans that are not EJB's. Annotation was found on type " + type));
        }
    }
}

