/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.transaction;

import org.jboss.logging.Logger;
import org.jboss.seam.persistence.util.ExceptionUtil;
import org.jboss.seam.transaction.SeamTransaction;

public abstract class Work<T> {
    private static final Logger log = Logger.getLogger(Work.class);

    protected abstract T work() throws Exception;

    protected boolean isNewTransactionRequired(boolean transactionActive) {
        return !transactionActive;
    }

    public final T workInTransaction(SeamTransaction transaction) throws Exception {
        boolean transactionActive = transaction.isActiveOrMarkedRollback() || transaction.isRolledBack();
        boolean newTransactionRequired = this.isNewTransactionRequired(transactionActive);
        try {
            if (newTransactionRequired) {
                log.debug((Object)"beginning transaction");
                transaction.begin();
            }
            T result = this.work();
            if (newTransactionRequired) {
                if (transaction.isMarkedRollback()) {
                    log.debug((Object)"rolling back transaction");
                    transaction.rollback();
                } else {
                    log.debug((Object)"committing transaction");
                    transaction.commit();
                }
            }
            return result;
        }
        catch (Exception e) {
            if (newTransactionRequired && transaction.getStatus() != 6) {
                if (ExceptionUtil.exceptionCausesRollback(e)) {
                    log.debug((Object)"rolling back transaction");
                    transaction.rollback();
                } else {
                    log.debug((Object)("committing transaction after ApplicationException(rollback=false):" + e.getMessage()));
                    transaction.commit();
                }
            } else if (transaction.getStatus() != 6 && ExceptionUtil.exceptionCausesRollback(e)) {
                transaction.setRollbackOnly();
            }
            throw e;
        }
    }
}

