package org.jboss.seam.remoting.examples.model;

import java.io.Serializable;
import java.util.Collection;
import java.util.Date;

import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
public class Person implements Serializable
{  
   private static final long serialVersionUID = 5652755541082449920L;
   
   private Integer personId;   
   private String firstName;
   private String lastName;
   private Date dateOfBirth;
   
   private Collection<Address> addresses;
   
   @Id @GeneratedValue
   public Integer getPersonId()
   {
      return personId;
   }
   
   public void setPersonId(Integer personId)
   {
      this.personId = personId;
   }
      
   public String getFirstName()
   {
      return firstName;
   }
   
   public void setFirstName(String firstName)
   {
      this.firstName = firstName;
   }
   
   public String getLastName()
   {
      return lastName;
   }
   
   public void setLastName(String lastName)
   {
      this.lastName = lastName;
   }
   
   @Temporal(TemporalType.DATE)
   public Date getDateOfBirth()
   {
      return dateOfBirth;
   }
   
   public void setDateOfBirth(Date dateOfBirth)
   {
      this.dateOfBirth = dateOfBirth;
   }
   
   @OneToMany(fetch = FetchType.LAZY, mappedBy = "person", 
         cascade = CascadeType.ALL, orphanRemoval = true)
   public Collection<Address> getAddresses()
   {
      return addresses;
   }
   
   public void setAddresses(Collection<Address> addresses)
   {
      this.addresses = addresses;
   }
}
