/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.remoting.examples.model;

import java.io.Serializable;
import java.util.ArrayList;
import javax.enterprise.context.Conversation;
import javax.enterprise.context.ConversationScoped;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import org.jboss.seam.remoting.annotations.WebRemote;
import org.jboss.seam.remoting.examples.model.Person;
import org.jboss.seam.transaction.Transactional;

@ConversationScoped
public class PersonAction
implements Serializable {
    private static final long serialVersionUID = -1923705862231821692L;
    @Inject
    EntityManager entityManager;
    @Inject
    Conversation conversation;
    private Person person;

    @WebRemote
    public void createPerson() {
        this.conversation.begin();
        this.person = new Person();
        this.person.setAddresses(new ArrayList());
    }

    @WebRemote
    public void editPerson(Integer personId) {
        this.conversation.begin();
        this.person = (Person)this.entityManager.find(Person.class, (Object)personId);
    }

    @WebRemote
    @Transactional
    public void savePerson() throws Exception {
        if (this.person.getPersonId() == null) {
            this.entityManager.persist((Object)this.person);
        } else {
            this.person = (Person)this.entityManager.merge((Object)this.person);
        }
        this.conversation.end();
    }

    public Person getPerson() {
        return this.person;
    }
}

