/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.render.template.resolver;

import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;
import org.jboss.seam.render.spi.TemplateResolver;
import org.jboss.seam.render.spi.TemplateResource;
import org.jboss.seam.render.template.resolver.ClassLoaderTemplateResolver;

public class ClassLoaderTemplateResource
implements TemplateResource<ClassLoader> {
    private final ClassLoaderTemplateResolver resolver;
    private final ClassLoader loader;
    private final String path;

    public ClassLoaderTemplateResource(ClassLoaderTemplateResolver resolver, ClassLoader loader, String path) {
        this.resolver = resolver;
        this.loader = loader;
        this.path = path;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public InputStream getInputStream() {
        return this.loader.getResourceAsStream(this.path);
    }

    @Override
    public ClassLoader getUnderlyingResource() {
        return this.loader;
    }

    @Override
    public TemplateResolver<ClassLoader> getResolvedBy() {
        return this.resolver;
    }

    @Override
    public long getLastModified() {
        URLConnection connection = null;
        try {
            connection = this.loader.getResource(this.path).openConnection();
            return connection.getLastModified();
        }
        catch (IOException e) {
            throw new RuntimeException("Could not determine last modified time for resource [" + this.path + "]", e);
        }
    }
}

