/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.render.template.resolver;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.jboss.seam.render.spi.TemplateResolver;
import org.jboss.seam.render.spi.TemplateResource;
import org.jboss.seam.render.template.resolver.TemplateResolutionException;
import org.jboss.seam.render.util.Assert;
import org.jboss.seam.solder.util.service.ServiceLoader;

public class TemplateResolverFactory
implements TemplateResolver<Object> {
    private static ServiceLoader<TemplateResolver> resolvers = null;
    Set<TemplateResolver> addedResolvers = new HashSet<TemplateResolver>();

    public void addResolver(TemplateResolver resolver) {
        this.addedResolvers.add(resolver);
    }

    @Override
    public TemplateResource resolve(String target) throws TemplateResolutionException {
        TemplateResolver resolver;
        Assert.notNull(target, "Target resource must not be null.");
        this.loadResolvers();
        TemplateResource resource = null;
        Iterator i$ = this.addedResolvers.iterator();
        while (i$.hasNext() && (resource = (resolver = i$.next()).resolve(target)) == null) {
        }
        if (resource == null) {
            i$ = resolvers.iterator();
            while (i$.hasNext() && (resource = (resolver = (TemplateResolver)i$.next()).resolve(target)) == null) {
            }
        }
        if (resource == null) {
            throw new TemplateResolutionException("Could not load requested resource: [" + target + "] with any configured resolvers:" + resolvers + ", " + this.addedResolvers);
        }
        return resource;
    }

    @Override
    public TemplateResource resolveRelative(TemplateResource origin, String relativePath) throws TemplateResolutionException {
        Assert.notNull(origin, "Origin resource was null when attempting to resolve [" + relativePath + "]");
        Assert.notNull(relativePath, "Relative resource path must not be null when attempting to resolve from base resource [" + origin.getPath() + "]");
        TemplateResource result = null;
        TemplateResolver resolver = origin.getResolvedBy();
        if (resolver != null) {
            result = resolver.resolveRelative(origin, relativePath);
        }
        if (result == null) {
            result = this.resolve(relativePath);
        }
        if (result == null) {
            throw new TemplateResolutionException("Could not load requested resource: [" + relativePath + "] using origin resolver [" + origin.getResolvedBy() + "] from resource [" + origin.getPath() + "]");
        }
        return result;
    }

    private synchronized void loadResolvers() {
        if (resolvers == null) {
            resolvers = ServiceLoader.load(TemplateResolver.class);
        }
    }
}

