/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.maven.helper;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import org.apache.maven.plugin.logging.Log;
import org.jboss.seam.maven.helper.XMLGenerator;
import org.w3c.dom.Element;

public class ConverterGenerator {
    private List<File> converterSources = new ArrayList<File>();
    private Log log;
    private String sourceDirectory;
    private String targetDirectory;

    public ConverterGenerator(String sourceDirectory, String targetDirectory, Log log) {
        this.sourceDirectory = sourceDirectory;
        this.targetDirectory = targetDirectory;
        this.log = log;
    }

    public void addFile(File file) throws FileNotFoundException {
        if (this.fileIsConverterSource(file)) {
            this.converterSources.add(file);
        }
    }

    private boolean fileIsConverterSource(File file) throws FileNotFoundException {
        Scanner scanner;
        String find;
        if (file.getName().endsWith(".java") && (find = (scanner = new Scanner(file)).findWithinHorizon("@FacesConverter", 0)) != null) {
            this.log.info((CharSequence)("Identified " + file.getName() + " as Converter source code"));
            return true;
        }
        return false;
    }

    public void generateConverters() throws Exception {
        this.log.info((CharSequence)"Generating Converters");
        XMLGenerator xmlGenerator = new XMLGenerator(this.log);
        File outXML = new File(this.targetDirectory + "/generated-sources/main/resources/META-INF", "s.taglib.xml");
        ArrayList<Element> tagsToAdd = new ArrayList<Element>();
        for (File source : this.converterSources) {
            String classFromSource = source.getAbsolutePath().replace(this.sourceDirectory, "").replace(File.separatorChar, '.').replace(".java", "").substring(1);
            File facesConfigXML = this.findCorrespondentConfig(classFromSource);
            if (facesConfigXML == null) continue;
            Element tag = xmlGenerator.getFaceletsTagElementFromFacesconfig(facesConfigXML, facesConfigXML.getName().replace(".xml", ""), "converter");
            tagsToAdd.add(tag);
        }
        xmlGenerator.updateFile(outXML, tagsToAdd);
    }

    private File findCorrespondentConfig(String classFromSource) throws FileNotFoundException {
        String whereToFind = this.sourceDirectory.replace("/java", "/config/component");
        this.log.debug((CharSequence)("Searching correspondent config for " + classFromSource + " in " + whereToFind));
        File componentFolder = new File(whereToFind);
        for (File f : componentFolder.listFiles()) {
            Scanner scanner;
            String find;
            if (!f.isFile() || (find = (scanner = new Scanner(f)).findWithinHorizon(classFromSource, 0)) == null) continue;
            return f;
        }
        return null;
    }
}

