/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.maven.helper;

import java.io.File;
import java.io.FileNotFoundException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.jboss.seam.maven.helper.ConverterGenerator;
import org.jboss.seam.maven.helper.ValidatorGenerator;

public class SeamGeneratorValidatorAndConvertersMojo
extends AbstractMojo {
    protected String sourceDirectory;
    private String targetDirectory;
    private ConverterGenerator converterGenerator;
    private ValidatorGenerator validatorGenerator;

    public void execute() throws MojoExecutionException {
        this.converterGenerator = new ConverterGenerator(this.sourceDirectory, this.targetDirectory, this.getLog());
        this.validatorGenerator = new ValidatorGenerator(this.targetDirectory, this.getLog());
        try {
            File sourceFolder = new File(this.sourceDirectory);
            this.getLog().info((CharSequence)("Source Folder: " + sourceFolder));
            this.visitFolder(sourceFolder);
            this.converterGenerator.generateConverters();
            this.visitFolder(new File(sourceFolder.getParent(), "config/component"));
            this.validatorGenerator.generateValidators();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error on Generator", e);
        }
    }

    private void visitFolder(File sourceFolder) throws FileNotFoundException {
        for (File file : sourceFolder.listFiles()) {
            if (file.isDirectory()) {
                this.visitFolder(file);
                continue;
            }
            this.converterGenerator.addFile(file);
            this.validatorGenerator.addFile(file);
        }
    }
}

