/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security.examples.id_provider;

import java.io.Serializable;
import javax.faces.context.FacesContext;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletResponse;
import org.jboss.seam.security.external.saml.api.SamlIdentityProviderApi;
import org.jboss.seam.security.external.saml.api.SamlIdpSession;

@Named
public class Identity
implements Serializable {
    private static final long serialVersionUID = 3739296115750412807L;
    @Inject
    private SamlIdentityProviderApi samlIdp;

    public void localLogin(String userName) {
        this.samlIdp.localLogin(this.samlIdp.createNameId(userName, null, null), null);
    }

    public void remoteLogin(String spEntityId) {
        this.samlIdp.remoteLogin(spEntityId, null, (HttpServletResponse)FacesContext.getCurrentInstance().getExternalContext().getResponse());
    }

    public void localLogout() {
        this.samlIdp.localLogout();
    }

    public void globalLogout() {
        this.samlIdp.globalLogout((HttpServletResponse)FacesContext.getCurrentInstance().getExternalContext().getResponse());
    }

    public boolean isLoggedIn() {
        return this.samlIdp.getSession() != null;
    }

    public void redirectToLoginIfNotLoggedIn() {
        if (!this.isLoggedIn()) {
            this.redirectToViewId("/Login.xhtml");
        }
    }

    public SamlIdpSession getSamlIdpSession() {
        return this.samlIdp.getSession();
    }

    private void redirectToViewId(String viewId) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        FacesContext.getCurrentInstance().getApplication().getNavigationHandler().handleNavigation(facesContext, null, viewId + "?faces-redirect=true");
    }
}

