/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security.examples.id_provider;

import javax.enterprise.inject.Model;
import javax.faces.context.FacesContext;
import javax.inject.Inject;
import javax.servlet.http.HttpServletResponse;
import org.jboss.seam.security.examples.id_provider.Identity;
import org.jboss.seam.security.external.dialogues.api.DialogueManager;
import org.jboss.seam.security.external.saml.api.SamlIdentityProviderApi;

@Model
public class Login {
    @Inject
    private SamlIdentityProviderApi samlIdentityProviderApi;
    private String userName;
    private String dialogueId;
    @Inject
    private DialogueManager dialogueManager;
    @Inject
    private Identity identity;

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getDialogueId() {
        return this.dialogueId;
    }

    public void setDialogueId(String dialogueId) {
        this.dialogueId = dialogueId;
    }

    public String login() {
        this.identity.localLogin(this.userName);
        if (this.dialogueId != null) {
            this.dialogueManager.attachDialogue(this.dialogueId);
            this.samlIdentityProviderApi.authenticationSucceeded((HttpServletResponse)FacesContext.getCurrentInstance().getExternalContext().getResponse());
            this.dialogueManager.detachDialogue();
            return "SAML_LOGIN";
        }
        return "LOCAL_LOGIN";
    }

    public void cancel() {
        if (this.dialogueId == null) {
            throw new IllegalStateException("cancel method can only be called during a SAML login");
        }
        this.dialogueManager.attachDialogue(this.dialogueId);
        this.samlIdentityProviderApi.authenticationFailed((HttpServletResponse)FacesContext.getCurrentInstance().getExternalContext().getResponse());
        this.dialogueManager.detachDialogue();
    }
}

