/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security.examples.id_provider;

import java.io.IOException;
import javax.inject.Inject;
import javax.servlet.ServletContext;
import org.jboss.logging.Logger;
import org.jboss.seam.security.examples.id_provider.Identity;
import org.jboss.seam.security.external.api.ResponseHolder;
import org.jboss.seam.security.external.saml.api.SamlIdentityProviderApi;
import org.jboss.seam.security.external.saml.api.SamlIdpSession;
import org.jboss.seam.security.external.spi.SamlIdentityProviderSpi;

public class SamlIdentityProviderSpiImpl
implements SamlIdentityProviderSpi {
    @Inject
    private Logger log;
    @Inject
    private ServletContext servletContext;
    @Inject
    private Identity identity;
    @Inject
    private SamlIdentityProviderApi idpApi;

    public void authenticate(ResponseHolder responseHolder) {
        if (this.identity.isLoggedIn()) {
            this.idpApi.authenticationSucceeded(responseHolder.getResponse());
        } else {
            responseHolder.redirectWithDialoguePropagation(this.servletContext.getContextPath() + "/Login.jsf");
        }
    }

    public void globalLogoutFailed(ResponseHolder responseHolder) {
        try {
            responseHolder.getResponse().sendRedirect(this.servletContext.getContextPath() + "/SingleLogoutFailed.jsf");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void globalLogoutSucceeded(ResponseHolder responseHolder) {
        try {
            responseHolder.getResponse().sendRedirect(this.servletContext.getContextPath() + "/Login.jsf");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void loggedOut(SamlIdpSession session) {
        this.log.info((Object)("Unsolicited logout for user " + session.getPrincipal().getNameId().getValue() + "."));
    }
}

