/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security.examples.idmconsole.action;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.enterprise.context.Conversation;
import javax.enterprise.context.ConversationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.seam.transaction.Transactional;
import org.picketlink.idm.api.Attribute;
import org.picketlink.idm.api.Group;
import org.picketlink.idm.api.IdentitySession;
import org.picketlink.idm.api.IdentityType;
import org.picketlink.idm.api.Role;
import org.picketlink.idm.api.RoleType;
import org.picketlink.idm.api.User;
import org.picketlink.idm.common.exception.FeatureNotSupportedException;
import org.picketlink.idm.common.exception.IdentityException;
import org.picketlink.idm.impl.api.SimpleAttribute;
import org.picketlink.idm.impl.api.model.SimpleRole;
import org.picketlink.idm.impl.api.model.SimpleUser;

@Named
@ConversationScoped
public class UserAction
implements Serializable {
    private static final long serialVersionUID = 5820385095080724087L;
    private static final String ATTRIBUTE_NAME_USER_ENABLED = "USER_ENABLED";
    private String firstname;
    private String lastname;
    private String username;
    private String password;
    private String confirm;
    private Collection<Role> roles;
    private boolean enabled;
    private boolean newUserFlag;
    @Inject
    IdentitySession identitySession;
    @Inject
    Conversation conversation;
    Collection<RoleType> roleTypes;
    Collection<Group> roleGroups;
    private RoleType roleType;
    private Group roleGroup;

    public void createUser() {
        this.conversation.begin();
        this.roles = new ArrayList();
        this.newUserFlag = true;
    }

    public void editUser(String username) throws IdentityException, FeatureNotSupportedException {
        Object value;
        this.conversation.begin();
        this.username = username;
        this.roles = new ArrayList();
        Collection roleTypes = this.identitySession.getRoleManager().findUserRoleTypes((User)new SimpleUser(username));
        for (RoleType roleType : roleTypes) {
            this.roles.addAll(this.identitySession.getRoleManager().findRoles(username, roleType.getName()));
        }
        Attribute enabledAttr = this.identitySession.getAttributesManager().getAttribute(username, ATTRIBUTE_NAME_USER_ENABLED);
        this.enabled = enabledAttr != null ? ((value = enabledAttr.getValue()) != null ? (Boolean.class.isAssignableFrom(value.getClass()) ? ((Boolean)value).booleanValue() : Boolean.valueOf((String)value).booleanValue()) : true) : true;
        this.newUserFlag = false;
    }

    public void addRole() throws IdentityException, FeatureNotSupportedException {
        this.roleTypes = this.identitySession.getRoleManager().findRoleTypes();
        this.roleGroups = this.identitySession.getPersistenceManager().findGroup("GROUP");
        this.roleType = null;
        this.roleGroup = null;
    }

    public String roleSave() {
        this.roles.add(new SimpleRole(this.roleType, null, this.roleGroup));
        return "success";
    }

    @Transactional
    public void deleteUser(String username) throws IdentityException {
        this.identitySession.getPersistenceManager().removeUser((User)new SimpleUser(username), true);
    }

    @Transactional
    public String save() throws IdentityException, FeatureNotSupportedException {
        if (this.newUserFlag) {
            return this.saveNewUser();
        }
        return this.saveExistingUser();
    }

    public void cancel() {
        this.conversation.end();
    }

    private String saveNewUser() throws IdentityException, FeatureNotSupportedException {
        if (this.password == null || !this.password.equals(this.confirm)) {
            return "failure";
        }
        User user = this.identitySession.getPersistenceManager().createUser(this.username);
        this.identitySession.getAttributesManager().updatePassword(user, this.password);
        for (Role role : this.roles) {
            this.identitySession.getRoleManager().createRole(role.getRoleType(), user, role.getGroup());
        }
        this.conversation.end();
        return "success";
    }

    private String saveExistingUser() throws IdentityException, FeatureNotSupportedException {
        User user = this.identitySession.getPersistenceManager().findUser(this.username);
        if (this.password != null && !"".equals(this.password)) {
            if (!this.password.equals(this.confirm)) {
                return "failure";
            }
            this.identitySession.getAttributesManager().updatePassword(user, this.password);
        }
        ArrayList grantedRoles = new ArrayList();
        Collection roleTypes = this.identitySession.getRoleManager().findUserRoleTypes(user);
        for (RoleType roleType : roleTypes) {
            grantedRoles.addAll(this.identitySession.getRoleManager().findRoles(this.username, roleType.getName()));
        }
        if (grantedRoles != null) {
            for (Role role : grantedRoles) {
                if (this.roles.contains(role)) continue;
                this.identitySession.getRoleManager().removeRole(role);
            }
        }
        for (Role role : this.roles) {
            if (grantedRoles != null && grantedRoles.contains(role)) continue;
            this.identitySession.getRoleManager().createRole(role.getRoleType(), user, role.getGroup());
        }
        this.identitySession.getAttributesManager().updateAttributes((IdentityType)user, new Attribute[]{new SimpleAttribute(ATTRIBUTE_NAME_USER_ENABLED, (Object)this.enabled)});
        this.conversation.end();
        return "success";
    }

    public String getFirstname() {
        return this.firstname;
    }

    public void setFirstname(String firstname) {
        this.firstname = firstname;
    }

    public String getLastname() {
        return this.lastname;
    }

    public void setLastname(String lastname) {
        this.lastname = lastname;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getConfirm() {
        return this.confirm;
    }

    public void setConfirm(String confirm) {
        this.confirm = confirm;
    }

    public Collection<Role> getRoles() {
        return this.roles;
    }

    public void setRoles(List<Role> roles) {
        this.roles = roles;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public RoleType getRoleType() {
        return this.roleType;
    }

    public void setRoleType(RoleType roleType) {
        this.roleType = roleType;
    }

    public Group getRoleGroup() {
        return this.roleGroup;
    }

    public void setRoleGroup(Group roleGroup) {
        this.roleGroup = roleGroup;
    }

    public Collection<RoleType> getRoleTypes() {
        return this.roleTypes;
    }

    public Collection<Group> getRoleGroups() {
        return this.roleGroups;
    }
}

