/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security.external.openid;

import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Typed;
import javax.inject.Inject;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletResponse;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.jboss.seam.security.external.EntityBean;
import org.jboss.seam.security.external.JaxbContext;
import org.jboss.seam.security.external.ResponseHandler;
import org.jboss.seam.security.external.dialogues.api.Dialogued;
import org.jboss.seam.security.external.jaxb.xrds.LocalID;
import org.jboss.seam.security.external.jaxb.xrds.ObjectFactory;
import org.jboss.seam.security.external.jaxb.xrds.Service;
import org.jboss.seam.security.external.jaxb.xrds.Type;
import org.jboss.seam.security.external.jaxb.xrds.URIPriorityAppendPattern;
import org.jboss.seam.security.external.jaxb.xrds.XRD;
import org.jboss.seam.security.external.jaxb.xrds.XRDS;
import org.jboss.seam.security.external.openid.OpenIdProviderAuthenticationService;
import org.jboss.seam.security.external.openid.OpenIdProviderBeanApi;
import org.jboss.seam.security.external.openid.OpenIdProviderRequest;
import org.jboss.seam.security.external.openid.OpenIdService;
import org.jboss.seam.security.external.spi.OpenIdProviderSpi;

@Typed(value={OpenIdProviderBean.class})
public class OpenIdProviderBean
extends EntityBean
implements OpenIdProviderBeanApi {
    @Inject
    private Instance<OpenIdProviderRequest> openIdProviderRequest;
    @Inject
    private OpenIdProviderAuthenticationService openIdSingleLoginSender;
    @Inject
    private ServletContext servletContext;
    @Inject
    private Instance<OpenIdProviderSpi> openIdProviderSpi;
    @Inject
    @JaxbContext(value={ObjectFactory.class})
    private JAXBContext jaxbContext;
    @Inject
    private ResponseHandler responseHandler;

    @Override
    public String getServiceURL(OpenIdService service) {
        String path = this.servletContext.getContextPath() + "/openid/OP/" + service.getName();
        return this.createURL(path);
    }

    public String getRealm() {
        return this.createURL("");
    }

    @Override
    public String getXrdsURL() {
        return this.getServiceURL(OpenIdService.XRDS_SERVICE);
    }

    @Override
    public void writeOpIdentifierXrds(Writer writer) {
        try {
            ObjectFactory objectFactory = new ObjectFactory();
            XRDS xrds = objectFactory.createXRDS();
            XRD xrd = objectFactory.createXRD();
            Type type = objectFactory.createType();
            type.setValue("http://specs.openid.net/auth/2.0/server");
            URIPriorityAppendPattern uri = objectFactory.createURIPriorityAppendPattern();
            uri.setValue(this.getServiceURL(OpenIdService.OPEN_ID_SERVICE));
            Service service = objectFactory.createService();
            service.getType().add(type);
            service.getURI().add(uri);
            xrd.getService().add(service);
            xrds.getOtherelement().add(xrd);
            Marshaller marshaller = this.jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.marshal((Object)xrds, writer);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void writeClaimedIdentifierXrds(Writer writer, String opLocalIdentifier) {
        try {
            ObjectFactory objectFactory = new ObjectFactory();
            XRDS xrds = objectFactory.createXRDS();
            XRD xrd = objectFactory.createXRD();
            Type type = objectFactory.createType();
            type.setValue("http://specs.openid.net/auth/2.0/signon");
            URIPriorityAppendPattern uri = objectFactory.createURIPriorityAppendPattern();
            uri.setValue(this.getServiceURL(OpenIdService.OPEN_ID_SERVICE));
            Service service = objectFactory.createService();
            service.getType().add(type);
            service.getURI().add(uri);
            LocalID localId = new LocalID();
            localId.setValue(opLocalIdentifier);
            service.getLocalID().add(localId);
            xrd.getService().add(service);
            xrds.getOtherelement().add(xrd);
            Marshaller marshaller = this.jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.marshal((Object)xrds, writer);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getOpLocalIdentifierForUserName(String userName) {
        try {
            return this.createURL(this.getUsersPath() + URLEncoder.encode(userName, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getUserNameFromOpLocalIdentifier(String opLocalIdentifier) {
        String prefix = this.createURL(this.getUsersPath());
        if (opLocalIdentifier.startsWith(prefix)) {
            String urlEncodedUserName = opLocalIdentifier.replace(prefix, "");
            try {
                return URLDecoder.decode(urlEncodedUserName, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public String getUsersPath() {
        return this.servletContext.getContextPath() + "/users/";
    }

    @Override
    public String getUsersUrlPrefix() {
        return this.createURL(this.getUsersPath());
    }

    @Override
    @Dialogued(join=true)
    public void authenticationFailed(HttpServletResponse response) {
        this.openIdSingleLoginSender.sendAuthenticationResponse(false, null, response);
    }

    @Override
    @Dialogued(join=true)
    public void authenticationSucceeded(String userName, HttpServletResponse response) {
        ((OpenIdProviderRequest)this.openIdProviderRequest.get()).setUserName(userName);
        if (((OpenIdProviderRequest)this.openIdProviderRequest.get()).getRequestedAttributes() == null) {
            this.openIdSingleLoginSender.sendAuthenticationResponse(true, null, response);
        } else {
            ((OpenIdProviderSpi)this.openIdProviderSpi.get()).fetchParameters(((OpenIdProviderRequest)this.openIdProviderRequest.get()).getRequestedAttributes(), this.responseHandler.createResponseHolder(response));
        }
    }

    @Override
    @Dialogued(join=true)
    public void setAttributes(Map<String, List<String>> attributeValues, HttpServletResponse response) {
        this.openIdSingleLoginSender.sendAuthenticationResponse(true, attributeValues, response);
    }
}

