/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security.external.openid;

import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.jboss.seam.security.external.InvalidRequestException;
import org.jboss.seam.security.external.OpenIdPrincipalImpl;
import org.jboss.seam.security.external.ResponseHandler;
import org.jboss.seam.security.external.dialogues.DialogueBean;
import org.jboss.seam.security.external.dialogues.api.Dialogued;
import org.jboss.seam.security.external.openid.OpenIdRequest;
import org.jboss.seam.security.external.openid.OpenIdRpBeanApi;
import org.jboss.seam.security.external.openid.OpenIdService;
import org.jboss.seam.security.external.openid.api.OpenIdPrincipal;
import org.jboss.seam.security.external.openid.api.OpenIdRequestedAttribute;
import org.jboss.seam.security.external.spi.OpenIdRelyingPartySpi;
import org.jboss.seam.solder.logging.Logger;
import org.openid4java.OpenIDException;
import org.openid4java.consumer.ConsumerManager;
import org.openid4java.consumer.VerificationResult;
import org.openid4java.discovery.DiscoveryInformation;
import org.openid4java.discovery.Identifier;
import org.openid4java.message.AuthRequest;
import org.openid4java.message.AuthSuccess;
import org.openid4java.message.MessageExtension;
import org.openid4java.message.ParameterList;
import org.openid4java.message.ax.FetchRequest;
import org.openid4java.message.ax.FetchResponse;

@ApplicationScoped
public class OpenIdRpAuthenticationService {
    @Inject
    private OpenIdRequest openIdRequest;
    @Inject
    private ConsumerManager openIdConsumerManager;
    @Inject
    private Instance<OpenIdRelyingPartySpi> openIdRelyingPartySpi;
    @Inject
    private Instance<OpenIdRpBeanApi> relyingPartyBean;
    @Inject
    private ResponseHandler responseHandler;
    @Inject
    private Logger log;
    @Inject
    HttpSession session;
    @Inject
    private Instance<DialogueBean> dialogue;

    public void handleIncomingMessage(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws InvalidRequestException {
        this.processIncomingMessage(new ParameterList(httpRequest.getParameterMap()), httpRequest.getQueryString(), httpResponse);
    }

    public void processIncomingMessage(ParameterList parameterList, String queryString, HttpServletResponse httpResponse) {
        try {
            VerificationResult verification;
            Identifier identifier;
            DiscoveryInformation discovered = this.openIdRequest.getDiscoveryInformation();
            if (discovered == null) {
                throw new IllegalStateException("No discovery information found in OpenID request");
            }
            StringBuffer receivingURL = new StringBuffer(((OpenIdRpBeanApi)this.relyingPartyBean.get()).getServiceURL(OpenIdService.OPEN_ID_SERVICE));
            if (queryString != null && queryString.length() > 0) {
                receivingURL.append("?").append(queryString);
            }
            if ((identifier = (verification = this.openIdConsumerManager.verify(receivingURL.toString(), parameterList, discovered)).getVerifiedId()) != null) {
                AuthSuccess authSuccess = (AuthSuccess)verification.getAuthResponse();
                Map attributeValues = null;
                if (authSuccess.hasExtension("http://openid.net/srv/ax/1.0")) {
                    Map attrValues;
                    FetchResponse fetchResp = (FetchResponse)authSuccess.getExtension("http://openid.net/srv/ax/1.0");
                    attributeValues = attrValues = fetchResp.getAttributes();
                }
                OpenIdPrincipal principal = this.createPrincipal(identifier.getIdentifier(), discovered.getOPEndpoint(), attributeValues);
                ((OpenIdRelyingPartySpi)this.openIdRelyingPartySpi.get()).loginSucceeded(principal, this.responseHandler.createResponseHolder(httpResponse));
            } else {
                ((OpenIdRelyingPartySpi)this.openIdRelyingPartySpi.get()).loginFailed(verification.getStatusMsg(), this.responseHandler.createResponseHolder(httpResponse));
            }
        }
        catch (OpenIDException e) {
            this.responseHandler.sendError(400, e.getMessage(), httpResponse);
            return;
        }
        ((DialogueBean)this.dialogue.get()).setFinished(true);
    }

    @Dialogued(join=true)
    public void sendAuthRequest(String openId, List<OpenIdRequestedAttribute> attributes, HttpServletResponse response) {
        try {
            List discoveries = this.openIdConsumerManager.discover(openId);
            DiscoveryInformation discovered = this.openIdConsumerManager.associate(discoveries);
            this.openIdRequest.setDiscoveryInformation(discovered);
            String realm = ((OpenIdRpBeanApi)this.relyingPartyBean.get()).getRealm();
            String returnTo = ((OpenIdRpBeanApi)this.relyingPartyBean.get()).getServiceURL(OpenIdService.OPEN_ID_SERVICE) + "?dialogueId=" + ((DialogueBean)this.dialogue.get()).getId();
            AuthRequest authReq = this.openIdConsumerManager.authenticate(discovered, returnTo, realm);
            if (attributes != null && attributes.size() > 0) {
                FetchRequest fetch = FetchRequest.createFetchRequest();
                for (OpenIdRequestedAttribute attribute : attributes) {
                    fetch.addAttribute(attribute.getAlias(), attribute.getTypeUri(), attribute.isRequired());
                }
                authReq.addExtension((MessageExtension)fetch);
            }
            String url = authReq.getDestinationUrl(true);
            this.responseHandler.sendHttpRedirectToUserAgent(url, response);
        }
        catch (OpenIDException e) {
            this.log.warn((Object)"Authentication failed", (Throwable)e);
            ((OpenIdRelyingPartySpi)this.openIdRelyingPartySpi.get()).loginFailed(e.getMessage(), this.responseHandler.createResponseHolder(response));
        }
    }

    private OpenIdPrincipal createPrincipal(String identifier, URL openIdProvider, Map<String, List<String>> attributeValues) {
        return new OpenIdPrincipalImpl(identifier, openIdProvider, attributeValues);
    }
}

