/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security.external.saml;

import java.security.PublicKey;
import java.util.List;
import javax.security.cert.CertificateException;
import javax.security.cert.X509Certificate;
import javax.xml.bind.JAXBElement;
import org.jboss.seam.security.external.jaxb.samlv2.metadata.KeyDescriptorType;
import org.jboss.seam.security.external.jaxb.samlv2.metadata.KeyTypes;
import org.jboss.seam.security.external.jaxb.xmldsig.X509DataType;
import org.jboss.seam.security.external.saml.SamlProfile;
import org.jboss.seam.security.external.saml.SamlService;

public abstract class SamlExternalEntity {
    private String entityId;
    private PublicKey publicKey;

    public SamlExternalEntity(String entityId, List<KeyDescriptorType> keyDescriptors) {
        this.entityId = entityId;
        this.setPublicKey(keyDescriptors);
    }

    public String getEntityId() {
        return this.entityId;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    private void setPublicKey(List<KeyDescriptorType> keyDescriptors) {
        for (KeyDescriptorType keyDescriptor : keyDescriptors) {
            if (!keyDescriptor.getUse().equals((Object)KeyTypes.SIGNING)) continue;
            for (Object content : keyDescriptor.getKeyInfo().getContent()) {
                if (!(content instanceof JAXBElement) || !(((JAXBElement)content).getValue() instanceof X509DataType)) continue;
                X509DataType X509Data = (X509DataType)((JAXBElement)content).getValue();
                for (Object object : X509Data.getX509IssuerSerialOrX509SKIOrX509SubjectName()) {
                    JAXBElement el;
                    if (!(object instanceof JAXBElement) || !(el = (JAXBElement)object).getName().getLocalPart().equals("X509Certificate")) continue;
                    byte[] certificate = (byte[])el.getValue();
                    try {
                        X509Certificate cert = X509Certificate.getInstance(certificate);
                        this.publicKey = cert.getPublicKey();
                    }
                    catch (CertificateException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
    }

    public abstract SamlService getService(SamlProfile var1);

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.entityId == null ? 0 : this.entityId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SamlExternalEntity other = (SamlExternalEntity)obj;
        return !(this.entityId == null ? other.entityId != null : !this.entityId.equals(other.entityId));
    }
}

