/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security.external.saml;

import org.jboss.seam.security.external.saml.SamlProfile;

public enum SamlServiceType {
    SAML_SINGLE_SIGN_ON_SERVICE("SingleSignOnService", SamlProfile.SINGLE_SIGN_ON),
    SAML_ASSERTION_CONSUMER_SERVICE("AssertionConsumerService", SamlProfile.SINGLE_SIGN_ON),
    SAML_SINGLE_LOGOUT_SERVICE("SingleLogoutService", SamlProfile.SINGLE_LOGOUT),
    SAML_META_DATA_SERVICE("MetaDataService", null);

    private String name;
    private SamlProfile profile;

    private SamlServiceType(String name, SamlProfile profile) {
        this.name = name;
        this.profile = profile;
    }

    public String getName() {
        return this.name;
    }

    public SamlProfile getProfile() {
        return this.profile;
    }

    public static SamlServiceType getByName(String name) {
        for (SamlServiceType service : SamlServiceType.values()) {
            if (!service.getName().equals(name)) continue;
            return service;
        }
        return null;
    }
}

