/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security.external.saml;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;

public class SamlSigningKey {
    private PrivateKey privateKey;
    private X509Certificate certificate;

    public SamlSigningKey(String keyStoreUrl, String keyStorePass, String signingKeyAlias, String signingKeyPass) {
        if (signingKeyPass == null) {
            signingKeyPass = keyStorePass;
        }
        this.getSigningKeyPair(keyStoreUrl, keyStorePass, signingKeyAlias, signingKeyPass);
    }

    private void getSigningKeyPair(String keyStoreUrl, String keyStorePass, String signingKeyAlias, String signingKeyPass) {
        String classPathPrefix = "classpath:";
        try {
            InputStream keyStoreStream;
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            if (keyStoreUrl.startsWith("classpath:")) {
                keyStoreStream = this.getClass().getResourceAsStream(keyStoreUrl.substring("classpath:".length()));
                if (keyStoreStream == null) {
                    throw new RuntimeException("Keystore " + keyStoreUrl + " could not be loaded from the classpath.");
                }
            } else {
                keyStoreStream = new URL(keyStoreUrl).openStream();
            }
            char[] keyStorePwd = keyStorePass != null ? keyStorePass.toCharArray() : null;
            keyStore.load(keyStoreStream, keyStorePwd);
            this.certificate = (X509Certificate)keyStore.getCertificate(signingKeyAlias);
            char[] signingKeyPwd = signingKeyPass != null ? signingKeyPass.toCharArray() : null;
            this.privateKey = (PrivateKey)keyStore.getKey(signingKeyAlias, signingKeyPwd);
            if (this.privateKey == null) {
                throw new RuntimeException("Key with alias " + signingKeyAlias + " was not found in keystore " + keyStoreUrl);
            }
        }
        catch (KeyStoreException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (CertificateException e) {
            throw new RuntimeException(e);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (UnrecoverableKeyException e) {
            throw new RuntimeException(e);
        }
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public X509Certificate getCertificate() {
        return this.certificate;
    }
}

