/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security.external.saml;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jboss.seam.security.external.Base64;
import org.jboss.seam.security.external.InvalidRequestException;
import org.jboss.seam.security.external.JaxbContext;
import org.jboss.seam.security.external.dialogues.api.DialogueManager;
import org.jboss.seam.security.external.jaxb.samlv2.protocol.RequestAbstractType;
import org.jboss.seam.security.external.jaxb.samlv2.protocol.ResponseType;
import org.jboss.seam.security.external.jaxb.samlv2.protocol.StatusResponseType;
import org.jboss.seam.security.external.saml.SamlDialogue;
import org.jboss.seam.security.external.saml.SamlEntityBean;
import org.jboss.seam.security.external.saml.SamlExternalEntity;
import org.jboss.seam.security.external.saml.SamlIdpOrSp;
import org.jboss.seam.security.external.saml.SamlProfile;
import org.jboss.seam.security.external.saml.SamlRedirectMessage;
import org.jboss.seam.security.external.saml.SamlRequestOrResponse;
import org.jboss.seam.security.external.saml.SamlServiceType;
import org.jboss.seam.security.external.saml.SamlSignatureUtilForPostBinding;
import org.jboss.seam.security.external.saml.SamlSignatureUtilForRedirectBinding;
import org.jboss.seam.security.external.saml.SamlUtils;
import org.jboss.seam.security.external.saml.idp.SamlIdpBeanApi;
import org.jboss.seam.security.external.saml.idp.SamlIdpSingleLogoutService;
import org.jboss.seam.security.external.saml.idp.SamlIdpSingleSignOnService;
import org.jboss.seam.security.external.saml.sp.SamlSpBeanApi;
import org.jboss.seam.security.external.saml.sp.SamlSpSingleLogoutService;
import org.jboss.seam.security.external.saml.sp.SamlSpSingleSignOnService;
import org.jboss.solder.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

@ApplicationScoped
public class SamlMessageReceiver {
    @Inject
    private Logger log;
    @Inject
    private DialogueManager dialogueManager;
    @Inject
    private Instance<SamlDialogue> samlDialogue;
    @Inject
    private SamlSpSingleLogoutService samlSpSingleLogoutService;
    @Inject
    private SamlIdpSingleLogoutService samlIdpSingleLogoutService;
    @Inject
    private SamlSpSingleSignOnService samlSpSingleSignOnService;
    @Inject
    private SamlIdpSingleSignOnService samlIdpSingleSignOnService;
    @Inject
    private Instance<SamlEntityBean> samlEntityBean;
    @Inject
    private Instance<SamlSpBeanApi> samlSpBean;
    @Inject
    private Instance<SamlIdpBeanApi> samlIdpBean;
    @Inject
    private SamlSignatureUtilForPostBinding signatureUtilForPostBinding;
    @Inject
    private SamlSignatureUtilForRedirectBinding signatureUtilForRedirectBinding;
    @Inject
    @JaxbContext(value={RequestAbstractType.class, StatusResponseType.class})
    private JAXBContext jaxbContext;

    public void handleIncomingSamlMessage(SamlServiceType service, HttpServletRequest httpRequest, HttpServletResponse httpResponse, SamlIdpOrSp idpOrSp) throws InvalidRequestException {
        String issuerEntityId;
        InputStream is;
        SamlRequestOrResponse samlRequestOrResponse;
        String samlMessage;
        String samlRequestParam = httpRequest.getParameter("SAMLRequest");
        String samlResponseParam = httpRequest.getParameter("SAMLResponse");
        if (samlRequestParam != null && samlResponseParam == null) {
            samlMessage = samlRequestParam;
            samlRequestOrResponse = SamlRequestOrResponse.REQUEST;
        } else if (samlRequestParam == null && samlResponseParam != null) {
            samlMessage = samlResponseParam;
            samlRequestOrResponse = SamlRequestOrResponse.RESPONSE;
        } else {
            throw new InvalidRequestException("SAML message should either have a SAMLRequest parameter or a SAMLResponse parameter");
        }
        if (httpRequest.getMethod().equals("POST")) {
            byte[] decodedMessage = Base64.decode(samlMessage);
            is = new ByteArrayInputStream(decodedMessage);
        } else {
            byte[] base64Decoded = Base64.decode(samlMessage);
            ByteArrayInputStream bais = new ByteArrayInputStream(base64Decoded);
            is = new InflaterInputStream(bais, new Inflater(true));
        }
        Document document = this.getDocument(is);
        RequestAbstractType samlRequestMessage = null;
        StatusResponseType samlResponseMessage = null;
        if (samlRequestOrResponse.isRequest()) {
            samlRequestMessage = this.getSamlRequest(document);
            issuerEntityId = samlRequestMessage.getIssuer().getValue();
        } else {
            samlResponseMessage = this.getSamlResponse(document);
            issuerEntityId = samlResponseMessage.getIssuer().getValue();
        }
        this.log.debug((Object)("Received: " + SamlUtils.getDocumentAsString(document)));
        try {
            if (samlRequestOrResponse.isRequest() || samlResponseMessage.getInResponseTo() == null) {
                String destination;
                String string = destination = samlRequestOrResponse.isRequest() ? samlRequestMessage.getDestination() : samlResponseMessage.getDestination();
                if (!((SamlEntityBean)this.samlEntityBean.get()).getServiceURL(service).equals(destination)) {
                    throw new InvalidRequestException("Destination (" + destination + ") is not valid.");
                }
                this.dialogueManager.beginDialogue();
                ((SamlDialogue)this.samlDialogue.get()).setExternalProviderMessageId(samlRequestOrResponse.isRequest() ? samlRequestMessage.getID() : samlResponseMessage.getID());
                SamlExternalEntity externalProvider = ((SamlEntityBean)this.samlEntityBean.get()).getExternalSamlEntityByEntityId(issuerEntityId);
                if (externalProvider == null) {
                    throw new InvalidRequestException("Received message from unknown entity id " + issuerEntityId);
                }
                ((SamlDialogue)this.samlDialogue.get()).setExternalProvider(externalProvider);
            } else {
                String dialogueId = samlResponseMessage.getInResponseTo();
                if (!this.dialogueManager.isExistingDialogue(dialogueId)) {
                    throw new InvalidRequestException("No request that corresponds with the received response");
                }
                this.dialogueManager.attachDialogue(dialogueId);
                if (!((SamlDialogue)this.samlDialogue.get()).getExternalProvider().getEntityId().equals(issuerEntityId)) {
                    throw new InvalidRequestException("Identity samlEntityBean of request and response do not match");
                }
            }
            SamlExternalEntity externalProvider = ((SamlEntityBean)this.samlEntityBean.get()).getExternalSamlEntityByEntityId(issuerEntityId);
            boolean validate = samlRequestOrResponse.isRequest() ? (service.getProfile() == SamlProfile.SINGLE_SIGN_ON ? (idpOrSp == SamlIdpOrSp.IDP ? ((SamlIdpBeanApi)this.samlIdpBean.get()).isWantAuthnRequestsSigned() : ((SamlSpBeanApi)this.samlSpBean.get()).isWantAssertionsSigned()) : (idpOrSp == SamlIdpOrSp.IDP ? ((SamlIdpBeanApi)this.samlIdpBean.get()).isWantSingleLogoutMessagesSigned() : ((SamlSpBeanApi)this.samlSpBean.get()).isWantSingleLogoutMessagesSigned())) : samlResponseMessage instanceof ResponseType;
            if (validate) {
                if (httpRequest.getMethod().equals("POST")) {
                    this.signatureUtilForPostBinding.validateSignature(externalProvider.getPublicKey(), document);
                } else {
                    SamlRedirectMessage redirectMessage = new SamlRedirectMessage(samlRequestOrResponse, (ServletRequest)httpRequest);
                    this.signatureUtilForRedirectBinding.validateSignature(redirectMessage, externalProvider.getPublicKey());
                }
            }
            if (service.getProfile() == SamlProfile.SINGLE_SIGN_ON) {
                if (samlRequestOrResponse.isRequest()) {
                    this.samlIdpSingleSignOnService.processSPRequest(httpRequest, httpResponse, samlRequestMessage);
                } else {
                    this.samlSpSingleSignOnService.processIDPResponse(httpRequest, httpResponse, samlResponseMessage);
                }
            } else if (samlRequestOrResponse.isRequest()) {
                if (idpOrSp == SamlIdpOrSp.IDP) {
                    this.samlIdpSingleLogoutService.processSPRequest(httpRequest, httpResponse, samlRequestMessage);
                } else {
                    this.samlSpSingleLogoutService.processIDPRequest(httpRequest, httpResponse, samlRequestMessage);
                }
            } else if (idpOrSp == SamlIdpOrSp.IDP) {
                this.samlIdpSingleLogoutService.processSPResponse(httpRequest, httpResponse, samlResponseMessage);
            } else {
                this.samlSpSingleLogoutService.processIDPResponse(httpRequest, httpResponse, samlResponseMessage);
            }
        }
        catch (Exception e) {
            if (this.dialogueManager.isAttached()) {
                this.dialogueManager.endDialogue();
            }
            throw new RuntimeException(e);
        }
        this.dialogueManager.detachDialogue();
    }

    private RequestAbstractType getSamlRequest(Document document) throws InvalidRequestException {
        try {
            Unmarshaller unmarshaller = this.jaxbContext.createUnmarshaller();
            JAXBElement jaxbRequest = (JAXBElement)unmarshaller.unmarshal((Node)document);
            RequestAbstractType request = (RequestAbstractType)jaxbRequest.getValue();
            return request;
        }
        catch (JAXBException e) {
            throw new InvalidRequestException("SAML message could not be parsed", (Exception)((Object)e));
        }
    }

    private StatusResponseType getSamlResponse(Document document) throws InvalidRequestException {
        try {
            Unmarshaller unmarshaller = this.jaxbContext.createUnmarshaller();
            JAXBElement jaxbResponseType = (JAXBElement)unmarshaller.unmarshal((Node)document);
            StatusResponseType statusResponse = (StatusResponseType)jaxbResponseType.getValue();
            return statusResponse;
        }
        catch (JAXBException e) {
            throw new InvalidRequestException("SAML message could not be parsed", (Exception)((Object)e));
        }
    }

    private Document getDocument(InputStream is) throws InvalidRequestException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setXIncludeAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder.parse(is);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (SAXException e) {
            throw new InvalidRequestException("SAML request could not be parsed", e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

