/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security.external.saml;

import java.util.LinkedList;
import java.util.List;
import org.jboss.seam.security.external.jaxb.samlv2.metadata.EndpointType;
import org.jboss.seam.security.external.saml.SamlEndpoint;
import org.jboss.seam.security.external.saml.SamlProfile;
import org.jboss.seam.security.external.saml.api.SamlBinding;

public class SamlService {
    private SamlProfile profile;
    private List<SamlEndpoint> serviceEndpoints = new LinkedList<SamlEndpoint>();

    public SamlService(SamlProfile profile, List<? extends EndpointType> endpoints) {
        this.profile = profile;
        for (EndpointType endpointType : endpoints) {
            SamlBinding samlBinding = null;
            if (endpointType.getBinding().endsWith("HTTP-Redirect")) {
                samlBinding = SamlBinding.HTTP_Redirect;
            } else if (endpointType.getBinding().endsWith("HTTP-POST")) {
                samlBinding = SamlBinding.HTTP_Post;
            }
            if (samlBinding == null) continue;
            SamlEndpoint samlEndpoint = new SamlEndpoint(this, samlBinding, endpointType.getLocation(), endpointType.getResponseLocation());
            this.serviceEndpoints.add(samlEndpoint);
        }
    }

    public SamlProfile getProfile() {
        return this.profile;
    }

    public List<SamlEndpoint> getServiceEndpoints() {
        return this.serviceEndpoints;
    }

    public SamlEndpoint getEndpointForBinding(SamlBinding samlBinding) {
        for (SamlEndpoint endpoint : this.serviceEndpoints) {
            if (endpoint.getBinding() != samlBinding) continue;
            return endpoint;
        }
        return null;
    }
}

