/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security.external.saml.idp;

import java.util.List;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.seam.security.external.InvalidRequestException;
import org.jboss.seam.security.external.ResponseHandler;
import org.jboss.seam.security.external.SamlNameIdImpl;
import org.jboss.seam.security.external.dialogues.DialogueBean;
import org.jboss.seam.security.external.dialogues.api.DialogueManager;
import org.jboss.seam.security.external.jaxb.samlv2.assertion.NameIDType;
import org.jboss.seam.security.external.jaxb.samlv2.protocol.LogoutRequestType;
import org.jboss.seam.security.external.jaxb.samlv2.protocol.RequestAbstractType;
import org.jboss.seam.security.external.jaxb.samlv2.protocol.StatusResponseType;
import org.jboss.seam.security.external.saml.SamlDialogue;
import org.jboss.seam.security.external.saml.SamlMessageFactory;
import org.jboss.seam.security.external.saml.SamlMessageSender;
import org.jboss.seam.security.external.saml.SamlProfile;
import org.jboss.seam.security.external.saml.api.SamlIdpSession;
import org.jboss.seam.security.external.saml.api.SamlNameId;
import org.jboss.seam.security.external.saml.api.SamlPrincipal;
import org.jboss.seam.security.external.saml.idp.SamlExternalServiceProvider;
import org.jboss.seam.security.external.saml.idp.SamlIdpIncomingLogoutDialogue;
import org.jboss.seam.security.external.saml.idp.SamlIdpOutgoingLogoutDialogue;
import org.jboss.seam.security.external.saml.idp.SamlIdpSessionImpl;
import org.jboss.seam.security.external.saml.idp.SamlIdpSessions;
import org.jboss.seam.security.external.spi.SamlIdentityProviderSpi;

public class SamlIdpSingleLogoutService {
    @Inject
    private SamlMessageFactory samlMessageFactory;
    @Inject
    private SamlMessageSender samlMessageSender;
    @Inject
    private SamlIdpSessions samlIdpSessions;
    @Inject
    private Instance<SamlIdentityProviderSpi> samlIdentityProviderSpi;
    @Inject
    private Instance<DialogueBean> dialogue;
    @Inject
    private Instance<SamlDialogue> samlDialogue;
    @Inject
    private Instance<SamlIdpIncomingLogoutDialogue> samlIdpIncomingLogoutDialogue;
    @Inject
    private Instance<SamlIdpOutgoingLogoutDialogue> samlIdpOutgoingLogoutDialogue;
    @Inject
    private DialogueManager dialogueManager;
    @Inject
    private ResponseHandler responseHandler;

    public void processSPRequest(HttpServletRequest httpRequest, HttpServletResponse httpResponse, RequestAbstractType request) throws InvalidRequestException {
        if (!(request instanceof LogoutRequestType)) {
            throw new InvalidRequestException("Request should be a single logout request.");
        }
        LogoutRequestType logoutRequest = (LogoutRequestType)request;
        NameIDType nameIdJaxb = logoutRequest.getNameID();
        SamlNameIdImpl samlNameId = new SamlNameIdImpl(nameIdJaxb.getValue(), nameIdJaxb.getFormat(), nameIdJaxb.getNameQualifier());
        ((SamlIdpIncomingLogoutDialogue)this.samlIdpIncomingLogoutDialogue.get()).setNameId(samlNameId);
        ((SamlIdpIncomingLogoutDialogue)this.samlIdpIncomingLogoutDialogue.get()).setSessionIndexes(logoutRequest.getSessionIndex());
        this.removeNextSessionParticipant(httpResponse);
    }

    public void handleIDPInitiatedSingleLogout(SamlPrincipal principal, List<String> indexes, HttpServletResponse response) {
        ((SamlIdpIncomingLogoutDialogue)this.samlIdpIncomingLogoutDialogue.get()).setNameId(principal.getNameId());
        ((SamlIdpIncomingLogoutDialogue)this.samlIdpIncomingLogoutDialogue.get()).setSessionIndexes(indexes);
        this.removeNextSessionParticipant(response);
    }

    private void removeNextSessionParticipant(HttpServletResponse response) {
        SamlNameId samlNameId = ((SamlIdpIncomingLogoutDialogue)this.samlIdpIncomingLogoutDialogue.get()).getNameId();
        List<String> sessionIndexes = ((SamlIdpIncomingLogoutDialogue)this.samlIdpIncomingLogoutDialogue.get()).getSessionIndexes();
        boolean readyForNow = false;
        while (!readyForNow) {
            SamlIdpSession sessionToRemove = null;
            for (SamlIdpSessionImpl session : this.samlIdpSessions.getSessions()) {
                if (!session.getPrincipal().getNameId().equals(samlNameId) || sessionIndexes != null && sessionIndexes.size() != 0 && !sessionIndexes.contains(session.getSessionIndex())) continue;
                sessionToRemove = session;
                break;
            }
            if (sessionToRemove != null) {
                if (sessionToRemove.getServiceProviders().size() != 0) {
                    SamlExternalServiceProvider sp = sessionToRemove.getServiceProviders().iterator().next();
                    sessionToRemove.getServiceProviders().remove(sp);
                    if (sp == null || sp.equals(((SamlDialogue)this.samlDialogue.get()).getExternalProvider()) || sp.getService(SamlProfile.SINGLE_LOGOUT) == null) continue;
                    String incomingDialogueId = ((DialogueBean)this.dialogue.get()).getId();
                    this.dialogueManager.detachDialogue();
                    this.dialogueManager.beginDialogue();
                    ((SamlIdpOutgoingLogoutDialogue)this.samlIdpOutgoingLogoutDialogue.get()).setIncomingDialogueId(incomingDialogueId);
                    this.sendSingleLogoutRequestToSP(sessionToRemove, sp, response);
                    readyForNow = true;
                    continue;
                }
                this.samlIdpSessions.removeSession((SamlIdpSessionImpl)sessionToRemove);
                if (((SamlDialogue)this.samlDialogue.get()).getExternalProvider() == null) continue;
                ((SamlIdentityProviderSpi)this.samlIdentityProviderSpi.get()).loggedOut(sessionToRemove);
                continue;
            }
            this.finishSingleLogoutProcess(response);
            readyForNow = true;
        }
    }

    private void finishSingleLogoutProcess(HttpServletResponse response) {
        boolean failed = ((SamlIdpIncomingLogoutDialogue)this.samlIdpIncomingLogoutDialogue.get()).isFailed();
        if (((SamlDialogue)this.samlDialogue.get()).getExternalProvider() != null) {
            StatusResponseType statusResponse = this.samlMessageFactory.createStatusResponse(failed ? "urn:oasis:names:tc:SAML:2.0:status:Responder" : "urn:oasis:names:tc:SAML:2.0:status:Success", null);
            this.samlMessageSender.sendResponse(((SamlDialogue)this.samlDialogue.get()).getExternalProvider(), statusResponse, SamlProfile.SINGLE_LOGOUT, response);
        } else if (failed) {
            ((SamlIdentityProviderSpi)this.samlIdentityProviderSpi.get()).globalLogoutFailed(this.responseHandler.createResponseHolder(response));
        } else {
            ((SamlIdentityProviderSpi)this.samlIdentityProviderSpi.get()).globalLogoutSucceeded(this.responseHandler.createResponseHolder(response));
        }
        ((DialogueBean)this.dialogue.get()).setFinished(true);
    }

    public void processSPResponse(HttpServletRequest httpRequest, HttpServletResponse httpResponse, StatusResponseType statusResponse) {
        String incomingDialogueId = ((SamlIdpOutgoingLogoutDialogue)this.samlIdpOutgoingLogoutDialogue.get()).getIncomingDialogueId();
        this.dialogueManager.endDialogue();
        this.dialogueManager.attachDialogue(incomingDialogueId);
        if (statusResponse.getStatus() != null && !statusResponse.getStatus().getStatusCode().getValue().equals("urn:oasis:names:tc:SAML:2.0:status:Success")) {
            ((SamlIdpIncomingLogoutDialogue)this.samlIdpIncomingLogoutDialogue.get()).setFailed(true);
        }
        this.removeNextSessionParticipant(httpResponse);
    }

    public void sendSingleLogoutRequestToSP(SamlIdpSession session, SamlExternalServiceProvider sp, HttpServletResponse response) {
        LogoutRequestType logoutRequest = this.samlMessageFactory.createLogoutRequest(session.getPrincipal().getNameId(), ((SamlIdpSessionImpl)session).getSessionIndex());
        ((SamlDialogue)this.samlDialogue.get()).setExternalProvider(sp);
        this.samlMessageSender.sendRequest(sp, SamlProfile.SINGLE_LOGOUT, logoutRequest, response);
    }
}

