/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.jboss.seam.security.Identity;
import org.jboss.seam.security.IdentityImpl;
import org.jboss.seam.security.Secure;
import org.jboss.seam.security.annotations.PermissionCheck;
import org.jboss.seam.security.annotations.Restrict;
import org.jboss.seam.security.annotations.RoleCheck;
import org.jboss.seam.security.util.Strings;

@Secure
@Interceptor
public class SecurityInterceptor
implements Serializable {
    private static final long serialVersionUID = -6567750187000766925L;
    private volatile transient Map<Method, Restriction> restrictions = new HashMap<Method, Restriction>();
    @Inject
    BeanManager manager;
    @Inject
    Identity identity;

    @AroundInvoke
    public Object aroundInvoke(InvocationContext invocation) throws Exception {
        Restriction restriction;
        Method interfaceMethod = invocation.getMethod();
        if (!"hashCode".equals(interfaceMethod.getName()) && (restriction = this.getRestriction(interfaceMethod)) != null) {
            restriction.check(this.identity, invocation.getParameters());
        }
        return invocation.proceed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Restriction getRestriction(Method interfaceMethod) throws Exception {
        Object object;
        if (this.restrictions == null) {
            object = this;
            synchronized (object) {
                this.restrictions = new HashMap<Method, Restriction>();
            }
        }
        if (!this.restrictions.containsKey(interfaceMethod)) {
            object = this.restrictions;
            synchronized (object) {
                if (!this.restrictions.containsKey(interfaceMethod)) {
                    Restriction restriction = null;
                    Restrict restrict = null;
                    if (interfaceMethod.isAnnotationPresent(Restrict.class)) {
                        restrict = interfaceMethod.getAnnotation(Restrict.class);
                    } else if (interfaceMethod.getDeclaringClass().isAnnotationPresent(Restrict.class)) {
                        restrict = interfaceMethod.getDeclaringClass().getAnnotation(Restrict.class);
                    }
                    if (restrict != null) {
                        if (restriction == null) {
                            restriction = new Restriction();
                        }
                        if (Strings.isEmpty(restrict.value())) {
                            Bean bean = (Bean)this.manager.getBeans(interfaceMethod.getDeclaringClass(), new Annotation[0]).iterator().next();
                            restriction.setPermissionTarget(bean.getName());
                            restriction.setPermissionAction(interfaceMethod.getName());
                        } else {
                            restriction.setExpression(restrict.value());
                        }
                    }
                    for (Annotation annotation : interfaceMethod.getDeclaringClass().getAnnotations()) {
                        if (!annotation.annotationType().isAnnotationPresent(RoleCheck.class)) continue;
                        if (restriction == null) {
                            restriction = new Restriction();
                        }
                        restriction.addRoleRestriction(annotation.annotationType().getSimpleName().toLowerCase());
                    }
                    for (Annotation annotation : interfaceMethod.getAnnotations()) {
                        if (annotation.annotationType().isAnnotationPresent(PermissionCheck.class)) {
                            PermissionCheck permissionCheck = annotation.annotationType().getAnnotation(PermissionCheck.class);
                            Method valueMethod = null;
                            int i$ = 0;
                            Method[] arr$ = annotation.annotationType().getDeclaredMethods();
                            int len$ = arr$.length;
                            if (i$ < len$) {
                                Method m;
                                valueMethod = m = arr$[i$];
                            }
                            if (valueMethod != null) {
                                Object target;
                                if (restriction == null) {
                                    restriction = new Restriction();
                                }
                                if (!(target = valueMethod.invoke((Object)annotation, new Object[0])).equals(Void.TYPE)) {
                                    if (restriction == null) {
                                        restriction = new Restriction();
                                    }
                                    restriction.addMethodRestriction(target, this.getPermissionAction(permissionCheck, annotation));
                                }
                            }
                        }
                        if (!annotation.annotationType().isAnnotationPresent(RoleCheck.class)) continue;
                        if (restriction == null) {
                            restriction = new Restriction();
                        }
                        restriction.addRoleRestriction(annotation.annotationType().getSimpleName().toLowerCase());
                    }
                    for (int i = 0; i < interfaceMethod.getParameterAnnotations().length; ++i) {
                        Annotation[] annotations;
                        for (Annotation annotation : annotations = interfaceMethod.getParameterAnnotations()[i]) {
                            if (!annotation.annotationType().isAnnotationPresent(PermissionCheck.class)) continue;
                            PermissionCheck permissionCheck = annotation.annotationType().getAnnotation(PermissionCheck.class);
                            if (restriction == null) {
                                restriction = new Restriction();
                            }
                            restriction.addParameterRestriction(i, this.getPermissionAction(permissionCheck, annotation));
                        }
                    }
                    this.restrictions.put(interfaceMethod, restriction);
                    return restriction;
                }
            }
        }
        return this.restrictions.get(interfaceMethod);
    }

    private String getPermissionAction(PermissionCheck check, Annotation annotation) {
        if (!"".equals(check.value())) {
            return check.value();
        }
        return annotation.annotationType().getSimpleName().toLowerCase();
    }

    private class Restriction {
        private String expression;
        private String permissionTarget;
        private String permissionAction;
        private Map<String, Object> methodRestrictions;
        private Map<Integer, Set<String>> paramRestrictions;
        private Set<String> roleRestrictions;

        private Restriction() {
        }

        public void setExpression(String expression) {
            this.expression = expression;
        }

        public void setPermissionTarget(String target) {
            this.permissionTarget = target;
        }

        public void setPermissionAction(String action) {
            this.permissionAction = action;
        }

        public void addMethodRestriction(Object target, String action) {
            if (this.methodRestrictions == null) {
                this.methodRestrictions = new HashMap<String, Object>();
            }
            this.methodRestrictions.put(action, target);
        }

        public void addRoleRestriction(String role) {
            if (this.roleRestrictions == null) {
                this.roleRestrictions = new HashSet<String>();
            }
            this.roleRestrictions.add(role);
        }

        public void addParameterRestriction(int index, String action) {
            Set<Object> actions = null;
            if (this.paramRestrictions == null) {
                this.paramRestrictions = new HashMap<Integer, Set<String>>();
            }
            if (!this.paramRestrictions.containsKey(index)) {
                actions = new HashSet();
                this.paramRestrictions.put(index, actions);
            } else {
                actions = this.paramRestrictions.get(index);
            }
            actions.add(action);
        }

        public void check(Identity identity, Object[] parameters) {
            if (IdentityImpl.isSecurityEnabled()) {
                if (this.methodRestrictions != null) {
                    for (String action : this.methodRestrictions.keySet()) {
                        identity.checkPermission(this.methodRestrictions.get(action), action);
                    }
                }
                if (this.paramRestrictions != null) {
                    for (Integer idx : this.paramRestrictions.keySet()) {
                        Set<String> actions = this.paramRestrictions.get(idx);
                        for (String action : actions) {
                            identity.checkPermission(parameters[idx], action);
                        }
                    }
                }
                if (this.roleRestrictions != null) {
                    // empty if block
                }
                if (this.permissionTarget != null && this.permissionAction != null) {
                    identity.checkPermission((Object)this.permissionTarget, this.permissionAction);
                }
            }
        }
    }
}

