/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security.management.picketlink;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import org.jboss.seam.security.management.picketlink.IdentityStoreConfiguration;
import org.picketlink.idm.api.IdentitySession;
import org.picketlink.idm.api.IdentitySessionFactory;
import org.picketlink.idm.api.event.EventListener;
import org.picketlink.idm.common.exception.IdentityConfigurationException;
import org.picketlink.idm.common.exception.IdentityException;
import org.picketlink.idm.impl.configuration.IdentityConfigurationImpl;
import org.picketlink.idm.impl.configuration.metadata.IdentityConfigurationMetaDataImpl;
import org.picketlink.idm.impl.configuration.metadata.IdentityRepositoryConfigurationMetaDataImpl;
import org.picketlink.idm.impl.configuration.metadata.IdentityStoreConfigurationMetaDataImpl;
import org.picketlink.idm.impl.configuration.metadata.IdentityStoreMappingMetaDataImpl;
import org.picketlink.idm.impl.configuration.metadata.RealmConfigurationMetaDataImpl;
import org.picketlink.idm.impl.repository.WrapperIdentityStoreRepository;
import org.picketlink.idm.spi.configuration.metadata.IdentityConfigurationMetaData;

@ApplicationScoped
public class IdentitySessionProducer
implements EventListener {
    private IdentitySessionFactory factory;
    private String defaultRealm = "default";
    private String defaultAttributeStoreId;
    private String defaultIdentityStoreId;
    @Inject
    BeanManager manager;
    @Inject
    Instance<EntityManager> entityManagerInstance;

    @Inject
    public void init() throws IdentityConfigurationException, IdentityException {
        IdentityConfigurationMetaDataImpl metadata = new IdentityConfigurationMetaDataImpl();
        ArrayList<IdentityStoreConfigurationMetaDataImpl> stores = new ArrayList<IdentityStoreConfigurationMetaDataImpl>();
        String defaultStoreId = null;
        Set storeBeans = this.manager.getBeans(IdentityStoreConfiguration.class, new Annotation[0]);
        for (Bean storeBean : storeBeans) {
            IdentityStoreConfiguration config = (IdentityStoreConfiguration)this.manager.getReference(storeBean, IdentityStoreConfiguration.class, this.manager.createCreationalContext((Contextual)storeBean));
            IdentityStoreConfigurationMetaDataImpl store = new IdentityStoreConfigurationMetaDataImpl();
            config.configure(store);
            if (defaultStoreId == null && store.getId() != null) {
                defaultStoreId = store.getId();
            }
            stores.add(store);
        }
        metadata.setIdentityStores(stores);
        RealmConfigurationMetaDataImpl realm = new RealmConfigurationMetaDataImpl();
        realm.setId(this.getDefaultRealm());
        realm.setIdentityMapping("USER");
        realm.setOptions(new HashMap());
        ArrayList<RealmConfigurationMetaDataImpl> realms = new ArrayList<RealmConfigurationMetaDataImpl>();
        realms.add(realm);
        metadata.setRealms(realms);
        ArrayList<IdentityRepositoryConfigurationMetaDataImpl> repositories = new ArrayList<IdentityRepositoryConfigurationMetaDataImpl>();
        IdentityRepositoryConfigurationMetaDataImpl repository = new IdentityRepositoryConfigurationMetaDataImpl();
        repository.setClassName(WrapperIdentityStoreRepository.class.getName());
        repository.setDefaultAttributeStoreId(this.defaultAttributeStoreId != null ? this.defaultAttributeStoreId : defaultStoreId);
        repository.setDefaultIdentityStoreId(this.defaultIdentityStoreId != null ? this.defaultIdentityStoreId : defaultStoreId);
        ArrayList<IdentityStoreMappingMetaDataImpl> mappings = new ArrayList<IdentityStoreMappingMetaDataImpl>();
        IdentityStoreMappingMetaDataImpl mapping = new IdentityStoreMappingMetaDataImpl();
        ArrayList<String> identityObjectTypes = new ArrayList<String>();
        identityObjectTypes.add("USER");
        identityObjectTypes.add("GROUP");
        mapping.setIdentityObjectTypeMappings(identityObjectTypes);
        mapping.setIdentityStoreId(this.defaultIdentityStoreId != null ? this.defaultIdentityStoreId : defaultStoreId);
        mappings.add(mapping);
        repository.setIdentityStoreToIdentityObjectTypeMappings(mappings);
        repositories.add(repository);
        metadata.setRepositories(repositories);
        IdentityConfigurationImpl config = new IdentityConfigurationImpl();
        config.configure((IdentityConfigurationMetaData)metadata);
        this.factory = config.buildIdentitySessionFactory();
    }

    @Produces
    @RequestScoped
    IdentitySession createIdentitySession() throws IdentityException {
        HashMap<String, Object> sessionOptions = new HashMap<String, Object>();
        sessionOptions.put("ENTITY_MANAGER", this.entityManagerInstance.get());
        IdentitySession session = this.factory.createIdentitySession(this.getDefaultRealm(), sessionOptions);
        session.registerListener((EventListener)this);
        return session;
    }

    public String getDefaultRealm() {
        return this.defaultRealm;
    }

    public void setDefaultRealm(String defaultRealm) {
        this.defaultRealm = defaultRealm;
    }

    public String getDefaultAttributeStoreId() {
        return this.defaultAttributeStoreId;
    }

    public void setDefaultAttributeStoreId(String defaultAttributeStoreId) {
        this.defaultAttributeStoreId = defaultAttributeStoreId;
    }

    public String getDefaultIdentityStoreId() {
        return this.defaultIdentityStoreId;
    }

    public void setDefaultIdentityStoreId(String defaultIdentityStoreId) {
        this.defaultIdentityStoreId = defaultIdentityStoreId;
    }
}

