/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security.permission;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.jboss.seam.security.annotations.permission.PermissionProperty;
import org.jboss.seam.security.annotations.permission.PermissionPropertyType;
import org.jboss.seam.security.permission.IdentifierPolicy;
import org.jboss.seam.security.permission.Permission;
import org.jboss.seam.security.permission.PermissionMetadata;
import org.jboss.seam.security.permission.PermissionStore;
import org.jboss.seam.solder.properties.Property;
import org.jboss.seam.solder.properties.query.PropertyCriteria;
import org.jboss.seam.solder.properties.query.PropertyQueries;
import org.picketlink.idm.spi.model.IdentityObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class JpaPermissionStore
implements PermissionStore,
Serializable {
    private static final long serialVersionUID = 4764590939669047915L;
    private Logger log = LoggerFactory.getLogger(JpaPermissionStore.class);
    private boolean enabled;
    private Class<?> identityPermissionClass;
    private Property<Object> identityProperty;
    private Property<?> relationshipTypeProperty;
    private Property<String> relationshipNameProperty;
    private Property<String> resourceProperty;
    private Property<Object> permissionProperty;
    private Map<Integer, String> queryCache = new HashMap<Integer, String>();
    private PermissionMetadata metadata;
    @Inject
    IdentifierPolicy identifierPolicy;
    @Inject
    BeanManager manager;
    @Inject
    Instance<EntityManager> entityManagerInstance;

    @Inject
    public void init() {
        this.metadata = new PermissionMetadata();
        if (this.identityPermissionClass == null) {
            this.log.debug("No identityPermissionClass set, JpaPermissionStore will be unavailable.");
            this.enabled = false;
            return;
        }
        this.initProperties();
    }

    protected void initProperties() {
        this.identityProperty = PropertyQueries.createQuery(this.identityPermissionClass).addCriteria((PropertyCriteria)new PropertyTypeCriteria(PermissionPropertyType.IDENTITY)).getFirstResult();
        if (this.identityProperty == null) {
            throw new RuntimeException("Invalid identityPermissionClass " + this.identityPermissionClass.getName() + " - required annotation @PermissionProperty(IDENTITY) not found on any field or method.");
        }
        this.relationshipTypeProperty = PropertyQueries.createQuery(this.identityPermissionClass).addCriteria((PropertyCriteria)new PropertyTypeCriteria(PermissionPropertyType.RELATIONSHIP_TYPE)).getFirstResult();
        if (this.relationshipTypeProperty == null) {
            throw new RuntimeException("Invalid identityPermissionClass " + this.identityPermissionClass.getName() + " - required annotation @PermissionProperty(RELATIONSHIP_TYPE) not found on any field or method.");
        }
        this.relationshipNameProperty = PropertyQueries.createQuery(this.identityPermissionClass).addCriteria((PropertyCriteria)new PropertyTypeCriteria(PermissionPropertyType.RELATIONSHIP_NAME)).getFirstResult();
        if (this.relationshipNameProperty == null) {
            throw new RuntimeException("Invalid identityPermissionClass " + this.identityPermissionClass.getName() + " - required annotation @PermissionProperty(RELATIONSHIP_NAME) not found on any field or method.");
        }
        this.resourceProperty = PropertyQueries.createQuery(this.identityPermissionClass).addCriteria((PropertyCriteria)new PropertyTypeCriteria(PermissionPropertyType.RESOURCE)).getFirstResult();
        if (this.resourceProperty == null) {
            throw new RuntimeException("Invalid identityPermissionClass " + this.identityPermissionClass.getName() + " - required annotation @PermissionProperty(RESOURCE) not found on any field or method.");
        }
        this.permissionProperty = PropertyQueries.createQuery(this.identityPermissionClass).addCriteria((PropertyCriteria)new PropertyTypeCriteria(PermissionPropertyType.PERMISSION)).getFirstResult();
        if (this.permissionProperty == null) {
            throw new RuntimeException("Invalid identityPermissionClass " + this.identityPermissionClass.getName() + " - required annotation @PermissionProperty(PERMISSION) not found on any field or method.");
        }
        this.enabled = true;
    }

    protected Query createPermissionQuery(Object target, Set<?> targets, IdentityObject identity) {
        if (target != null && targets != null) {
            throw new IllegalArgumentException("Cannot specify both target and targets");
        }
        int queryKey = target != null ? 1 : 0;
        queryKey |= targets != null ? 2 : 0;
        if (!this.queryCache.containsKey(queryKey |= identity != null ? 4 : 0)) {
            boolean conditionsAdded = false;
            StringBuilder q = new StringBuilder();
            q.append("select p from ");
            q.append(this.identityPermissionClass.getName());
            q.append(" p");
            if (target != null) {
                q.append(" where p.");
                q.append(this.resourceProperty.getName());
                q.append(" = :target");
                conditionsAdded = true;
            }
            if (targets != null) {
                q.append(" where p.");
                q.append(this.resourceProperty.getName());
                q.append(" in (:targets)");
                conditionsAdded = true;
            }
            if (identity != null) {
                q.append(conditionsAdded ? " and p." : " where p.");
                q.append(this.identityProperty.getName());
                q.append(" = :identity");
                conditionsAdded = true;
            }
            this.queryCache.put(queryKey, q.toString());
        }
        Query query = this.lookupEntityManager().createQuery(this.queryCache.get(queryKey));
        if (target != null) {
            query.setParameter("target", (Object)this.identifierPolicy.getIdentifier(target));
        }
        if (targets != null) {
            HashSet<String> identifiers = new HashSet<String>();
            for (Object t : targets) {
                identifiers.add(this.identifierPolicy.getIdentifier(t));
            }
            query.setParameter("targets", identifiers);
        }
        if (identity != null) {
            query.setParameter("identity", this.resolveIdentityEntity(identity));
        }
        return query;
    }

    public boolean grantPermission(Permission permission) {
        return this.updatePermissionActions(permission.getResource(), permission.getIdentity(), new String[]{permission.getPermission()}, true);
    }

    public boolean revokePermission(Permission permission) {
        return this.updatePermissionActions(permission.getResource(), permission.getIdentity(), new String[]{permission.getPermission()}, false);
    }

    protected boolean updatePermissionActions(Object resource, IdentityObject identity, String[] actions, boolean set) {
        try {
            List permissions = this.createPermissionQuery(resource, null, identity).getResultList();
            if (permissions.isEmpty()) {
                if (!set) {
                    return true;
                }
                PermissionMetadata.ActionSet actionSet = this.metadata.createActionSet(resource.getClass(), null);
                for (String action : actions) {
                    actionSet.add(action);
                }
                Object instance = this.identityPermissionClass.newInstance();
                this.resourceProperty.setValue(instance, (Object)this.identifierPolicy.getIdentifier(resource));
                this.permissionProperty.setValue(instance, (Object)actionSet.toString());
                this.identityProperty.setValue(instance, this.resolveIdentityEntity(identity));
                this.lookupEntityManager().persist(instance);
                return true;
            }
            Object instance = permissions.get(0);
            PermissionMetadata.ActionSet actionSet = this.metadata.createActionSet(resource.getClass(), this.permissionProperty.getValue(instance).toString());
            for (String action : actions) {
                if (set) {
                    actionSet.add(action);
                    continue;
                }
                actionSet.remove(action);
            }
            if (permissions.size() > 1) {
                for (Object p : permissions) {
                    actionSet.addMembers(this.permissionProperty.getValue(p).toString());
                    if (p.equals(instance)) continue;
                    this.lookupEntityManager().remove(p);
                }
            }
            if (!actionSet.isEmpty()) {
                this.permissionProperty.setValue(instance, (Object)actionSet.toString());
                this.lookupEntityManager().merge(instance);
            } else {
                this.lookupEntityManager().remove(instance);
            }
            return true;
        }
        catch (Exception ex) {
            throw new RuntimeException("Could not grant permission", ex);
        }
    }

    public boolean grantPermissions(List<Permission> permissions) {
        Map<Object, Map<IdentityObject, List<Permission>>> groupedPermissions = this.groupPermissions(permissions);
        for (Object resource : groupedPermissions.keySet()) {
            Map<IdentityObject, List<Permission>> recipientPermissions = groupedPermissions.get(resource);
            for (IdentityObject recipient : recipientPermissions.keySet()) {
                List<Permission> ps = recipientPermissions.get(recipient);
                String[] actions = new String[ps.size()];
                for (int i = 0; i < ps.size(); ++i) {
                    actions[i] = ps.get(i).getPermission();
                }
                this.updatePermissionActions(resource, recipient, actions, true);
            }
        }
        return true;
    }

    public boolean revokePermissions(List<Permission> permissions) {
        Map<Object, Map<IdentityObject, List<Permission>>> groupedPermissions = this.groupPermissions(permissions);
        for (Object target : groupedPermissions.keySet()) {
            Map<IdentityObject, List<Permission>> recipientPermissions = groupedPermissions.get(target);
            for (IdentityObject identity : recipientPermissions.keySet()) {
                List<Permission> ps = recipientPermissions.get(identity);
                String[] actions = new String[ps.size()];
                for (int i = 0; i < ps.size(); ++i) {
                    actions[i] = ps.get(i).getPermission();
                }
                this.updatePermissionActions(target, identity, actions, false);
            }
        }
        return true;
    }

    private Map<Object, Map<IdentityObject, List<Permission>>> groupPermissions(List<Permission> permissions) {
        HashMap<Object, Map<IdentityObject, List<Permission>>> groupedPermissions = new HashMap<Object, Map<IdentityObject, List<Permission>>>();
        for (Permission permission : permissions) {
            Map recipientPermissions;
            if (!groupedPermissions.containsKey(permission.getResource())) {
                groupedPermissions.put(permission.getResource(), new HashMap());
            }
            if (!(recipientPermissions = (Map)groupedPermissions.get(permission.getResource())).containsKey(permission.getIdentity())) {
                ArrayList<Permission> perms = new ArrayList<Permission>();
                perms.add(permission);
                recipientPermissions.put(permission.getIdentity(), perms);
                continue;
            }
            ((List)recipientPermissions.get(permission.getIdentity())).add(permission);
        }
        return groupedPermissions;
    }

    protected Object resolveIdentityEntity(IdentityObject identity) {
        return identity.getName();
    }

    public List<Permission> listPermissions(Set<Object> targets, String action) {
        return this.listPermissions(null, targets, action);
    }

    public List<Permission> listPermissions(Object target, String action) {
        return this.listPermissions(target, null, action);
    }

    protected List<Permission> listPermissions(Object resource, Set<Object> targets, String action) {
        if (this.identityPermissionClass == null) {
            return null;
        }
        if (resource != null && targets != null) {
            throw new IllegalArgumentException("Cannot specify both target and targets");
        }
        ArrayList<Permission> permissions = new ArrayList<Permission>();
        if (targets != null && targets.isEmpty()) {
            return permissions;
        }
        Query permissionQuery = targets != null ? this.createPermissionQuery(null, targets, null) : this.createPermissionQuery(resource, null, null);
        List userPermissions = permissionQuery.getResultList();
        HashMap<String, Object> identifierCache = null;
        if (targets != null) {
            identifierCache = new HashMap<String, Object>();
            for (Object t : targets) {
                identifierCache.put(this.identifierPolicy.getIdentifier(t), t);
            }
        }
        for (Object permission : userPermissions) {
            PermissionMetadata.ActionSet actionSet = null;
            if (targets == null || resource != null) {
                // empty if block
            }
            if (resource == null || action != null && (actionSet == null || !actionSet.contains(action))) continue;
            IdentityObject identity = null;
            if (action != null) {
                permissions.add(new Permission(resource, action, identity));
                continue;
            }
            for (String a : actionSet.members()) {
                permissions.add(new Permission(resource, a, identity));
            }
        }
        return permissions;
    }

    public List<Permission> listPermissions(Object target) {
        return this.listPermissions(target, null);
    }

    public List<String> listAvailableActions(Object target) {
        return this.metadata.listAllowableActions(target.getClass());
    }

    private EntityManager lookupEntityManager() {
        return (EntityManager)this.entityManagerInstance.get();
    }

    public Class<?> getIdentityPermissionClass() {
        return this.identityPermissionClass;
    }

    public void setIdentityPermissionClass(Class<?> identityPermissionClass) {
        this.identityPermissionClass = identityPermissionClass;
    }

    public void clearPermissions(Object resource) {
        EntityManager em = this.lookupEntityManager();
        String identifier = this.identifierPolicy.getIdentifier(resource);
        em.createQuery("delete from " + this.identityPermissionClass.getName() + " p where p." + this.resourceProperty.getName() + " = :resource").setParameter("resource", (Object)identifier).executeUpdate();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    private class PropertyTypeCriteria
    implements PropertyCriteria {
        private PermissionPropertyType pt;

        public PropertyTypeCriteria(PermissionPropertyType pt) {
            this.pt = pt;
        }

        public boolean fieldMatches(Field f) {
            return f.isAnnotationPresent(PermissionProperty.class) && f.getAnnotation(PermissionProperty.class).value().equals((Object)this.pt);
        }

        public boolean methodMatches(Method m) {
            return m.isAnnotationPresent(PermissionProperty.class) && m.getAnnotation(PermissionProperty.class).value().equals((Object)this.pt);
        }
    }
}

