/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security.permission;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import org.jboss.seam.security.permission.PermissionResolver;

@ApplicationScoped
public class PermissionMapper
implements Serializable {
    private static final long serialVersionUID = 7692687882996064772L;
    @Inject
    Instance<PermissionResolver> resolvers;
    @Inject
    BeanManager manager;

    public boolean resolvePermission(Object resource, String permission) {
        for (PermissionResolver resolver : this.resolvers) {
            if (!resolver.hasPermission(resource, permission)) continue;
            return true;
        }
        return false;
    }

    public void filterByPermission(Collection<?> collection, String action) {
        boolean homogenous = true;
        Class<?> targetClass = null;
        for (Object target : collection) {
            if (targetClass == null) {
                targetClass = target.getClass();
            }
            if (targetClass.equals(target.getClass())) continue;
            homogenous = false;
            break;
        }
        if (homogenous) {
            HashSet denied = new HashSet(collection);
            for (PermissionResolver resolver : this.resolvers) {
                resolver.filterSetByAction(denied, action);
            }
            for (Object target : denied) {
                collection.remove(target);
            }
        } else {
            Set denied;
            HashMap deniedByClass = new HashMap();
            for (Object obj : collection) {
                if (!deniedByClass.containsKey(obj.getClass())) {
                    denied = new HashSet();
                    denied.add(obj);
                    deniedByClass.put(obj.getClass(), denied);
                    continue;
                }
                ((Set)deniedByClass.get(obj.getClass())).add(obj);
            }
            for (Class cls : deniedByClass.keySet()) {
                denied = (Set)deniedByClass.get(cls);
                for (PermissionResolver resolver : this.resolvers) {
                    resolver.filterSetByAction(denied, action);
                }
                for (Object target : denied) {
                    collection.remove(target);
                }
            }
        }
    }
}

